/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import java.util.NoSuchElementException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.cdi.workspace.Workspace;
import org.uberfire.backend.server.cdi.workspace.WorkspaceManager;
import org.uberfire.backend.server.cdi.workspace.WorkspaceManagerPreferences;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceManagerTest {
    @Mock
    private WorkspaceManagerPreferences preferences;
    private WorkspaceManager workspaceManager;

    @Before
    public void setUp() {
        Mockito.when((Object)this.preferences.getCacheExpirationTime()).thenReturn((Object)10);
        Mockito.when((Object)this.preferences.getCacheExpirationUnit()).thenReturn((Object)"MINUTES");
        Mockito.when((Object)this.preferences.getCacheMaximumSize()).thenReturn((Object)3);
        this.workspaceManager = new WorkspaceManager(this.preferences);
        this.workspaceManager.initialize();
    }

    @Test
    public void testWorkspaceNotFound() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.workspaceManager.getWorkspace("none")).isInstanceOf(NoSuchElementException.class)).hasMessage("Workspace <<none>> not found");
    }

    @Test
    public void testCreateWorkspace() {
        Workspace workspace = this.workspaceManager.getOrCreateWorkspace("hendrix");
        Assert.assertEquals((Object)"hendrix", (Object)workspace.getName());
    }

    @Test
    public void testWorkspaceCount() {
        this.workspaceManager.getOrCreateWorkspace("hendrix");
        Assert.assertEquals((long)1L, (long)this.workspaceManager.getWorkspaceCount());
    }

    @Test
    public void testDeleteWorkspace() {
        Workspace workspace = this.workspaceManager.getOrCreateWorkspace("hendrix");
        Assert.assertEquals((long)1L, (long)this.workspaceManager.getWorkspaceCount());
        this.workspaceManager.delete(workspace);
        Assert.assertEquals((long)0L, (long)this.workspaceManager.getWorkspaceCount());
    }

    @Test
    public void testStoreBeansWithCacheSizeEviction() {
        Workspace workspace = this.workspaceManager.getOrCreateWorkspace("hendrix");
        this.workspaceManager.putBean(workspace, "a", new Object());
        this.workspaceManager.putBean(workspace, "b", new Object());
        this.workspaceManager.putBean(workspace, "c", new Object());
        this.workspaceManager.putBean(workspace, "d", new Object());
        this.workspaceManager.putBean(workspace, "e", new Object());
        Assert.assertEquals((long)3L, (long)this.workspaceManager.getBeansCount(workspace));
    }

    @Test
    public void testGetBeanDoesNotExists() {
        Workspace workspace = this.workspaceManager.getOrCreateWorkspace("hendrix");
        Assert.assertNull((Object)this.workspaceManager.getBean(workspace, "a"));
    }
}

