/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.FileSystem;
import org.uberfire.backend.repositories.NewRepositoryEvent;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.repositories.RepositoryFactory;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private RepositoryFactory repositoryFactory;
    @Inject
    private Event<NewRepositoryEvent> event;
    private Map<String, Repository> configuredRepositories = new HashMap<String, Repository>();
    private List<Repository> configuredRepositoriesList = new ArrayList<Repository>();

    @PostConstruct
    public void loadRepositories() {
        List repoConfigs = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (repoConfigs != null && !repoConfigs.isEmpty()) {
            for (ConfigGroup config : repoConfigs) {
                Repository repository = this.repositoryFactory.newRepository(config);
                this.configuredRepositories.put(repository.getAlias(), repository);
                this.configuredRepositoriesList.add(repository);
            }
        }
        this.ioService.onNewFileSystem(new IOService.NewFileSystemListener(){

            public void execute(FileSystem newFileSystem, String scheme, String name, Map<String, ?> env) {
                if (RepositoryServiceImpl.this.getRepository(name) == null) {
                    RepositoryServiceImpl.this.createRepository(scheme, name, env);
                }
            }
        });
    }

    public Repository getRepository(String alias) {
        return this.configuredRepositories.get(alias);
    }

    public Collection<Repository> getRepositories() {
        return this.configuredRepositoriesList;
    }

    public void createRepository(String scheme, String alias, Map<String, Object> env) {
        ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
        if (!env.containsKey("scheme")) {
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
        }
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            if (entry.getKey().startsWith("crypt:")) {
                repositoryConfig.addConfigItem((ConfigItem)this.configurationFactory.newSecuredConfigItem(entry.getKey(), entry.getValue().toString()));
                continue;
            }
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem(entry.getKey(), entry.getValue()));
        }
        Repository repo = this.createRepository(repositoryConfig);
        this.event.fire((Object)new NewRepositoryEvent(repo));
    }

    private Repository createRepository(ConfigGroup repositoryConfig) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
        this.configurationService.addConfiguration(repositoryConfig);
        this.configuredRepositories.put(repository.getAlias(), repository);
        this.configuredRepositoriesList.add(repository);
        return repository;
    }
}

