/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories.git;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.PasswordService;
import org.uberfire.backend.server.config.SecureConfigItem;
import org.uberfire.backend.server.repositories.RepositoryFactoryHelper;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GitRepositoryFactoryHelper
implements RepositoryFactoryHelper {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private PasswordService secureService;

    public boolean accept(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return "git".equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        final GitRepository repo = new GitRepository(repoConfig.getName());
        for (ConfigItem item : repoConfig.getItems()) {
            if (item instanceof SecureConfigItem) {
                repo.addEnvironmentParameter(item.getName(), (Object)this.secureService.decrypt(item.getValue().toString()));
                continue;
            }
            repo.addEnvironmentParameter(item.getName(), item.getValue());
        }
        if (!repo.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        FileSystem fs = null;
        URI uri = null;
        try {
            uri = URI.create(repo.getUri());
            fs = this.ioService.newFileSystem(uri, (Map)new HashMap<String, Object>(repo.getEnvironment()){
                {
                    super(x0);
                    if (!repo.getEnvironment().containsKey("origin")) {
                        this.put("init", true);
                    }
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = this.ioService.getFileSystem(uri);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getCause().getMessage());
        }
        Path defaultRoot = (Path)fs.getRootDirectories().iterator().next();
        for (Path path : fs.getRootDirectories()) {
            if (!path.toUri().toString().contains("/master@")) continue;
            defaultRoot = path;
            break;
        }
        repo.setRoot(Paths.convert(defaultRoot));
        repo.setPublicUri(fs.toString());
        return repo;
    }
}

