/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.repositories.RepositoryServiceImpl;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.security.FileSystemResourceAdaptor;
import org.uberfire.security.Resource;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationException;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.RoleDecisionManager;
import org.uberfire.security.impl.authz.DefaultRoleDecisionManager;
import org.uberfire.security.impl.authz.RuntimeResourceDecisionManager;
import org.uberfire.security.impl.authz.RuntimeResourceManager;

public class RepositoryAuthorizationManager
implements AuthorizationManager {
    private final RuntimeResourceDecisionManager decisionManager = new RuntimeResourceDecisionManager(new RuntimeResourceManager());
    private final RoleDecisionManager roleDecisionManager = new DefaultRoleDecisionManager();
    private final RepositoryServiceImpl repositoryService;

    public RepositoryAuthorizationManager(RepositoryServiceImpl repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean supports(Resource resource) {
        return resource != null && (resource instanceof Repository || resource instanceof FileSystem || resource instanceof FileSystemResourceAdaptor);
    }

    public boolean authorize(Resource resource, Subject subject) throws AuthorizationException {
        PortablePreconditions.checkNotNull((String)"subject", (Object)subject);
        Repository repo = resource instanceof FileSystem ? this.repositoryService.getRepository((FileSystem)resource) : (resource instanceof FileSystemResourceAdaptor ? this.repositoryService.getRepository(((FileSystemResourceAdaptor)resource).getFileSystem()) : (Repository)resource);
        AuthorizationResult finalResult = this.decisionManager.decide((Resource)repo, subject, this.roleDecisionManager);
        return finalResult.equals(AuthorizationResult.ACCESS_ABSTAIN) || finalResult.equals(AuthorizationResult.ACCESS_GRANTED);
    }
}

