/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories;

import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.server.config.SystemRepositoryChangedEvent;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=Arquillian.class)
public class RepositoryServiceTest {
    private static final String SCHEME = "git";
    private static final String UF_PLAYGROUND_ALIAS = "uf-playground";
    @Inject
    private RepositoryService repositoryService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @org.uberfire.backend.server.config.Repository
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage("org.uberfire.backend.server.cluster")).addPackage("org.uberfire.backend.server.config")).addPackage("org.uberfire.backend.server.deployment")).addPackage("org.uberfire.backend.server.io")).addPackage("org.uberfire.backend.server.organizationalunit")).addPackage("org.uberfire.backend.server.repositories")).addPackage("org.uberfire.backend.server.repositories.git")).addPackage("org.uberfire.backend.server.security")).addPackage("org.uberfire.backend.server.util")).addPackage("org.uberfire.backend")).addPackage("org.uberfire.backend.server")).addAsManifestResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void configure() {
        Assert.assertNotNull((Object)this.ioService);
        Assert.assertNotNull((Object)this.repositoryService);
        this.repositoryService.removeRepository(UF_PLAYGROUND_ALIAS);
    }

    @Test
    public void testGetRepositories() {
        Collection repositories = this.repositoryService.getRepositories();
        Assert.assertNotNull((Object)repositories);
        Assert.assertEquals((long)0L, (long)repositories.size());
    }

    @Test
    public void testCreateRepository() throws Exception {
        Repository ufRepo = this.repositoryService.createRepository(SCHEME, UF_PLAYGROUND_ALIAS, new HashMap());
        Assert.assertNotNull((Object)ufRepo);
        Repository ufRepoByRoot = this.repositoryService.getRepository(ufRepo.getRoot());
        Assert.assertNotNull((Object)ufRepoByRoot);
        Repository ufRepoByAlias = this.repositoryService.getRepository(UF_PLAYGROUND_ALIAS);
        Assert.assertNotNull((Object)ufRepoByAlias);
        Assert.assertEquals((Object)"master", (Object)ufRepo.getCurrentBranch());
        Assert.assertEquals((long)1L, (long)ufRepo.getBranches().size());
        this.repositoryService.removeRepository(UF_PLAYGROUND_ALIAS);
    }

    @Test
    public void testCreateRepositoryWithBranch() throws Exception {
        Repository ufRepo = this.repositoryService.createRepository(SCHEME, UF_PLAYGROUND_ALIAS, new HashMap());
        Assert.assertNotNull((Object)ufRepo);
        Repository ufRepoByRoot = this.repositoryService.getRepository(ufRepo.getRoot());
        Assert.assertNotNull((Object)ufRepoByRoot);
        Repository ufRepoByAlias = this.repositoryService.getRepository(UF_PLAYGROUND_ALIAS);
        Assert.assertNotNull((Object)ufRepoByAlias);
        Assert.assertEquals((Object)"master", (Object)ufRepo.getCurrentBranch());
        Assert.assertEquals((long)1L, (long)ufRepo.getBranches().size());
        Path path2 = this.ioService.get(URI.create("git://user_branch@uf-playground/myfile2.txt"));
        OutputStream outStream2 = this.ioService.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        this.repoChangedEvent.fire((Object)new SystemRepositoryChangedEvent());
        Repository ufRepoUpdated = this.repositoryService.getRepository(UF_PLAYGROUND_ALIAS);
        Assert.assertNotNull((Object)ufRepoUpdated);
        Assert.assertEquals((Object)"master", (Object)ufRepoUpdated.getCurrentBranch());
        Assert.assertEquals((long)2L, (long)ufRepoUpdated.getBranches().size());
        this.repositoryService.removeRepository(UF_PLAYGROUND_ALIAS);
    }

    @Test
    public void testChangeRepositoryBranch() throws Exception {
        Repository ufRepo = this.repositoryService.createRepository(SCHEME, UF_PLAYGROUND_ALIAS, new HashMap());
        Assert.assertNotNull((Object)ufRepo);
        Repository ufRepoByRoot = this.repositoryService.getRepository(ufRepo.getRoot());
        Assert.assertNotNull((Object)ufRepoByRoot);
        Repository ufRepoByAlias = this.repositoryService.getRepository(UF_PLAYGROUND_ALIAS);
        Assert.assertNotNull((Object)ufRepoByAlias);
        Assert.assertEquals((Object)"master", (Object)ufRepo.getCurrentBranch());
        Assert.assertEquals((long)1L, (long)ufRepo.getBranches().size());
        Path path2 = this.ioService.get(URI.create("git://user_branch@uf-playground/myfile2.txt"));
        OutputStream outStream2 = this.ioService.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        this.repoChangedEvent.fire((Object)new SystemRepositoryChangedEvent());
        Repository ufRepoUpdated = this.repositoryService.getRepository(UF_PLAYGROUND_ALIAS);
        Assert.assertNotNull((Object)ufRepoUpdated);
        Assert.assertEquals((Object)"master", (Object)ufRepoUpdated.getCurrentBranch());
        Assert.assertEquals((long)2L, (long)ufRepoUpdated.getBranches().size());
        HashMap<String, String> configUpdate = new HashMap<String, String>();
        configUpdate.put("branch", "user_branch");
        Repository onUserBranchUFRepo = this.repositoryService.updateRepository(ufRepoUpdated, configUpdate);
        Assert.assertNotNull((Object)onUserBranchUFRepo);
        Assert.assertEquals((Object)"user_branch", (Object)onUserBranchUFRepo.getCurrentBranch());
        Assert.assertEquals((long)2L, (long)onUserBranchUFRepo.getBranches().size());
        this.repositoryService.removeRepository(UF_PLAYGROUND_ALIAS);
    }

    @Test
    public void testCreateWriteToRemoveRepository() throws Exception {
        Repository ufRepo = this.repositoryService.createRepository(SCHEME, UF_PLAYGROUND_ALIAS, new HashMap());
        Assert.assertNotNull((Object)ufRepo);
        Thread.sleep(2000L);
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)ufRepo.getRoot()).resolve("new_file.txt"), "some new content", new OpenOption[0]);
        Assert.assertEquals((Object)"some new content", (Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)ufRepo.getRoot()).resolve("new_file.txt")));
        this.repositoryService.removeRepository(UF_PLAYGROUND_ALIAS);
    }
}

