/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.watch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutor;
import org.uberfire.backend.server.util.Filter;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.Identity;
import org.uberfire.security.impl.IdentityImpl;
import org.uberfire.workbench.events.ResourceAdded;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceEvent;
import org.uberfire.workbench.events.ResourceRenamed;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdated;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class IOWatchServiceExecutorImpl
implements IOWatchServiceExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOWatchServiceExecutorImpl.class);
    @Inject
    private Event<ResourceBatchChangesEvent> resourceBatchChanges;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Event<ResourceRenamedEvent> resourceRenamedEvent;
    @Inject
    private Event<ResourceDeletedEvent> resourceDeletedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;

    public void setEvents(Event<ResourceBatchChangesEvent> resourceBatchChanges, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<ResourceRenamedEvent> resourceRenamedEvent, Event<ResourceDeletedEvent> resourceDeletedEvent, Event<ResourceAddedEvent> resourceAddedEvent) {
        this.resourceBatchChanges = resourceBatchChanges;
        this.resourceUpdatedEvent = resourceUpdatedEvent;
        this.resourceRenamedEvent = resourceRenamedEvent;
        this.resourceDeletedEvent = resourceDeletedEvent;
        this.resourceAddedEvent = resourceAddedEvent;
    }

    @Override
    public void execute(WatchKey wk, Filter<WatchEvent<?>> filter) {
        List events = wk.pollEvents();
        WatchContext firstContext = null;
        if (events.size() > 1) {
            HashMap changes = new HashMap();
            for (WatchEvent event : events) {
                Pair<Path, ResourceChange> result;
                if (filter.doFilter(event)) continue;
                if (firstContext == null) {
                    firstContext = (WatchContext)event.context();
                }
                if ((result = this.buildChange(event)) == null) continue;
                if (!changes.containsKey(result.getK1())) {
                    changes.put(result.getK1(), new ArrayList());
                }
                ((Collection)changes.get(result.getK1())).add(result.getK2());
            }
            if (changes.size() == 1 && changes.values().size() == 1) {
                ResourceChange _event = (ResourceChange)((Collection)changes.values().iterator().next()).iterator().next();
                if (_event instanceof ResourceUpdated) {
                    this.resourceUpdatedEvent.fire((Object)((ResourceUpdatedEvent)this.toEvent((Path)changes.keySet().iterator().next(), _event, firstContext)));
                } else if (_event instanceof ResourceAdded) {
                    this.resourceAddedEvent.fire((Object)((ResourceAddedEvent)this.toEvent((Path)changes.keySet().iterator().next(), _event, firstContext)));
                } else if (_event instanceof ResourceRenamed) {
                    this.resourceRenamedEvent.fire((Object)((ResourceRenamedEvent)this.toEvent((Path)changes.keySet().iterator().next(), _event, firstContext)));
                } else if (_event instanceof ResourceDeleted) {
                    this.resourceDeletedEvent.fire((Object)((ResourceDeletedEvent)this.toEvent((Path)changes.keySet().iterator().next(), _event, firstContext)));
                }
            } else if (changes.size() > 1) {
                this.resourceBatchChanges.fire((Object)new ResourceBatchChangesEvent(changes, this.sessionInfo(firstContext)));
            }
        } else if (events.size() == 1) {
            try {
                WatchEvent event = (WatchEvent)events.get(0);
                if (!filter.doFilter(event)) {
                    if (event.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
                        this.resourceUpdatedEvent.fire(this.buildEvent(ResourceUpdatedEvent.class, event).getK2());
                    } else if (event.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
                        this.resourceAddedEvent.fire(this.buildEvent(ResourceAddedEvent.class, event).getK2());
                    } else if (event.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
                        this.resourceRenamedEvent.fire(this.buildEvent(ResourceRenamedEvent.class, event).getK2());
                    } else if (event.kind().equals(StandardWatchEventKind.ENTRY_DELETE)) {
                        this.resourceDeletedEvent.fire(this.buildEvent(ResourceDeletedEvent.class, event).getK2());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error during WatchService events fire.", (Throwable)ex);
            }
        }
    }

    private <T extends ResourceEvent> Pair<Path, T> buildEvent(Class<T> clazz, WatchEvent<?> event) {
        ResourceUpdatedEvent result;
        Path _affectedPath;
        WatchContext context = (WatchContext)event.context();
        if (event.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
            _affectedPath = Paths.convert(context.getOldPath());
            result = new ResourceUpdatedEvent(_affectedPath, this.sessionInfo(context));
        } else if (event.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
            _affectedPath = Paths.convert(context.getPath());
            result = new ResourceAddedEvent(_affectedPath, this.sessionInfo(context));
        } else if (event.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
            _affectedPath = Paths.convert(context.getOldPath());
            result = new ResourceRenamedEvent(_affectedPath, Paths.convert(context.getPath()), this.sessionInfo(context));
        } else if (event.kind().equals(StandardWatchEventKind.ENTRY_DELETE)) {
            _affectedPath = Paths.convert(context.getOldPath());
            result = new ResourceDeletedEvent(_affectedPath, this.sessionInfo(context));
        } else {
            _affectedPath = null;
            result = null;
        }
        if (_affectedPath == null) {
            return null;
        }
        return Pair.newPair((Object)_affectedPath, (Object)result);
    }

    private Pair<Path, ResourceChange> buildChange(WatchEvent<?> event) {
        ResourceUpdated result;
        Path _affectedPath;
        WatchContext context = (WatchContext)event.context();
        if (event.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
            _affectedPath = Paths.convert(context.getOldPath());
            result = new ResourceUpdated();
        } else if (event.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
            _affectedPath = Paths.convert(context.getPath());
            result = new ResourceAdded();
        } else if (event.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
            _affectedPath = Paths.convert(context.getOldPath());
            result = new ResourceRenamed(Paths.convert(context.getPath()));
        } else if (event.kind().equals(StandardWatchEventKind.ENTRY_DELETE)) {
            _affectedPath = Paths.convert(context.getOldPath());
            result = new ResourceDeleted();
        } else {
            _affectedPath = null;
            result = null;
        }
        if (_affectedPath == null) {
            return null;
        }
        return Pair.newPair((Object)_affectedPath, (Object)result);
    }

    private ResourceEvent toEvent(Path path, ResourceChange change, WatchContext context) {
        if (change instanceof ResourceUpdated) {
            return new ResourceUpdatedEvent(path, this.sessionInfo(context));
        }
        if (change instanceof ResourceAdded) {
            return new ResourceAddedEvent(path, this.sessionInfo(context));
        }
        if (change instanceof ResourceRenamed) {
            return new ResourceRenamedEvent(path, ((ResourceRenamed)change).getDestinationPath(), this.sessionInfo(context));
        }
        if (change instanceof ResourceDeleted) {
            return new ResourceDeletedEvent(path, this.sessionInfo(context));
        }
        return null;
    }

    private SessionInfo sessionInfo(WatchContext context) {
        String sessionId = context.getSessionId() == null ? "<system>" : context.getSessionId();
        String user = context.getUser() == null ? "<system>" : context.getUser();
        return new SessionInfoImpl(sessionId, (Identity)new IdentityImpl(user));
    }
}

