/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.watch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.uberfire.backend.server.io.watch.AsyncWatchService;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutor;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutorImpl;
import org.uberfire.backend.server.util.Filter;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.io.IOWatchService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

public abstract class AbstractIOWatchService
implements IOWatchService,
Filter<WatchEvent<?>> {
    private final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory());
    private final List<FileSystem> fileSystems = new ArrayList<FileSystem>();
    private final List<WatchService> watchServices = new ArrayList<WatchService>();
    protected boolean isDisposed = false;
    private boolean started;
    private Set<AsyncWatchService> watchThreads = new HashSet<AsyncWatchService>();
    @Inject
    private Event<ResourceBatchChangesEvent> resourceBatchChanges;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Event<ResourceRenamedEvent> resourceRenamedEvent;
    @Inject
    private Event<ResourceDeletedEvent> resourceDeletedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    private IOWatchServiceExecutor executor = null;
    private final Set<Future<?>> jobs = new CopyOnWriteArraySet();

    public AbstractIOWatchService() {
        boolean autostart = Boolean.parseBoolean(System.getProperty("org.uberfire.watcher.autostart", "true"));
        if (autostart) {
            this.start();
        }
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            for (final AsyncWatchService watchThread : this.watchThreads) {
                final IOWatchServiceExecutor watchServiceExecutor = this.getWatchServiceExecutor();
                this.jobs.add(this.executorService.submit((Runnable)new DescriptiveRunnable(){

                    public String getDescription() {
                        return watchThread.getDescription();
                    }

                    public void run() {
                        watchThread.execute(watchServiceExecutor);
                    }
                }));
            }
            this.watchThreads.clear();
        }
    }

    @PreDestroy
    protected void dispose() {
        this.isDisposed = true;
        for (WatchService watchService : this.watchServices) {
            watchService.close();
        }
        for (Future future : this.jobs) {
            if (future.isCancelled() || future.isDone()) continue;
            future.cancel(true);
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public boolean hasWatchService(FileSystem fs) {
        return this.fileSystems.contains(fs);
    }

    public void addWatchService(FileSystem fs, final WatchService ws) {
        this.fileSystems.add(fs);
        this.watchServices.add(ws);
        final AsyncWatchService asyncWatchService = new AsyncWatchService(){

            @Override
            public void execute(IOWatchServiceExecutor wsExecutor) {
                while (!AbstractIOWatchService.this.isDisposed) {
                    WatchKey wk;
                    try {
                        wk = ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    wsExecutor.execute(wk, AbstractIOWatchService.this);
                    boolean valid = wk.reset();
                    if (valid) continue;
                    break;
                }
            }

            @Override
            public String getDescription() {
                return AbstractIOWatchService.this.getClass().getName() + "(" + ws.toString() + ")";
            }
        };
        if (this.started) {
            final IOWatchServiceExecutor watchServiceExecutor = this.getWatchServiceExecutor();
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return asyncWatchService.getDescription();
                }

                public void run() {
                    asyncWatchService.execute(watchServiceExecutor);
                }
            });
        } else {
            this.watchThreads.add(asyncWatchService);
        }
    }

    public void configureOnEvent(@Observes ApplicationStarted applicationStartedEvent) {
        this.start();
    }

    protected IOWatchServiceExecutor getWatchServiceExecutor() {
        if (this.executor == null) {
            IOWatchServiceExecutor _executor = null;
            try {
                _executor = (IOWatchServiceExecutor)InitialContext.doLookup("java:module/IOWatchServiceExecutorImpl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_executor == null) {
                _executor = new IOWatchServiceExecutorImpl();
                ((IOWatchServiceExecutorImpl)_executor).setEvents(this.resourceBatchChanges, this.resourceUpdatedEvent, this.resourceRenamedEvent, this.resourceDeletedEvent, this.resourceAddedEvent);
            }
            this.executor = _executor;
        }
        return this.executor;
    }
}

