/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.backend.server.security.IOServiceSecuritySetup;
import org.uberfire.backend.server.security.MockAuthenticationService;
import org.uberfire.backend.server.security.MockSecuredFilesystemProvider;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class IOServiceSecuritySetupTest {
    @Mock
    Instance<AuthenticationService> authenticationManagers;
    @Mock
    Instance<AuthorizationManager> authorizationManagers;
    @InjectMocks
    IOServiceSecuritySetup setupBean;

    @Before
    public void setup() {
        System.setProperty("org.uberfire.io.auth", MockAuthenticationService.class.getName());
    }

    @After
    public void teardown() {
        System.clearProperty("org.uberfire.io.auth");
    }

    @Test
    public void testSystemPropertyAuthConfig() throws Exception {
        Mockito.when((Object)this.authenticationManagers.isUnsatisfied()).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationManagers.isUnsatisfied()).thenReturn((Object)true);
        this.setupBean.setup();
        MockSecuredFilesystemProvider mockFsp = MockSecuredFilesystemProvider.LATEST_INSTANCE;
        Assert.assertNotNull((Object)mockFsp.authenticator);
        Assert.assertNotNull((Object)mockFsp.authorizer);
        FileSystemUser user = mockFsp.authenticator.authenticate("fake", "fake");
        Assert.assertEquals((Object)MockAuthenticationService.FAKE_USER.getIdentifier(), (Object)user.getName());
        Assert.assertTrue((boolean)mockFsp.authorizer.authorize((FileSystem)Mockito.mock(FileSystem.class), user));
    }

    @Test
    public void testCustomAuthenticatorBean() throws Exception {
        Mockito.when((Object)this.authorizationManagers.isUnsatisfied()).thenReturn((Object)true);
        Mockito.when((Object)this.authenticationManagers.isUnsatisfied()).thenReturn((Object)false);
        AuthenticationService mockAuthenticationService = (AuthenticationService)Mockito.mock(AuthenticationService.class);
        Mockito.when((Object)this.authenticationManagers.get()).thenReturn((Object)mockAuthenticationService);
        this.setupBean.setup();
        FileSystemAuthenticator authenticator = MockSecuredFilesystemProvider.LATEST_INSTANCE.authenticator;
        authenticator.authenticate("fake", "fake");
        ((AuthenticationService)Mockito.verify((Object)mockAuthenticationService)).login("fake", "fake");
    }

    @Test
    public void testCustomAuthorizerBean() throws Exception {
        Mockito.when((Object)this.authenticationManagers.isUnsatisfied()).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationManagers.isUnsatisfied()).thenReturn((Object)false);
        AuthorizationManager mockAuthorizationManager = (AuthorizationManager)Mockito.mock(AuthorizationManager.class);
        Mockito.when((Object)this.authorizationManagers.get()).thenReturn((Object)mockAuthorizationManager);
        this.setupBean.setup();
        FileSystemAuthorizer installedAuthorizer = MockSecuredFilesystemProvider.LATEST_INSTANCE.authorizer;
        FileSystemAuthenticator installedAuthenticator = MockSecuredFilesystemProvider.LATEST_INSTANCE.authenticator;
        FileSystem mockfs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemUser fileSystemUser = installedAuthenticator.authenticate("fake", "fake");
        installedAuthorizer.authorize(mockfs, fileSystemUser);
        ((AuthorizationManager)Mockito.verify((Object)mockAuthorizationManager)).authorize((Resource)Mockito.any(FileSystemResourceAdaptor.class), (User)Mockito.any(User.class));
    }
}

