/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Set;
import javax.servlet.http.HttpSession;
import org.jboss.errai.bus.client.api.QueueSession;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.bus.client.api.builder.MessageBuildSendableWithReply;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.VFSLockServiceImpl;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class VFSLockServiceTest {
    @InjectMocks
    private VFSLockServiceImpl lockService;
    @Mock
    private IOService ioService;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private QueueSession queueSession;
    @Mock
    private HttpSession httpSession;
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"file-to-lock.txt", (String)"default://file-to-lock.txt");

    @Before
    public void setup() {
        this.setupRpcContext();
        UserImpl testUser = new UserImpl("testUser");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)testUser);
        Mockito.when((Object)this.queueSession.getAttribute(HttpSession.class, HttpSession.class.getName())).thenReturn((Object)this.httpSession);
    }

    @Test
    public void acquireLockSucceedsIfFileUnlocked() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        LockResult result = this.lockService.acquireLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals((Object)"testUser", (Object)result.getLockInfo().lockedBy());
        Assert.assertTrue((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void acquireLockSucceedsIfLockOwned() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"testUser");
        LockResult result = this.lockService.acquireLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals((Object)"testUser", (Object)result.getLockInfo().lockedBy());
        Assert.assertTrue((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void acquireLockFailsIfFileLocked() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"some-other-user");
        LockResult result = this.lockService.acquireLock(this.path);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals((Object)"some-other-user", (Object)result.getLockInfo().lockedBy());
        Assert.assertTrue((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void acquireLockUpdatesSession() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        this.lockService.acquireLock(this.path);
        ((HttpSession)Mockito.verify((Object)this.httpSession)).setAttribute((String)Matchers.eq((Object)"uf-locks"), Matchers.any(Set.class));
    }

    @Test
    public void releaseLockSucceedsIfLockOwned() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"testUser");
        LockResult result = this.lockService.releaseLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals(null, (Object)result.getLockInfo().lockedBy());
        Assert.assertFalse((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void releaseLockFailsIfLockNotOwned() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"some-other-user");
        try {
            this.lockService.releaseLock(this.path);
            Assert.fail((String)"Expected exception on attempt to release lock not owned by user");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void forceReleaseLockSucceedsIfLockNotOwned() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"some-other-user");
        LockResult result = this.lockService.forceReleaseLock(this.path);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals(null, (Object)result.getLockInfo().lockedBy());
        Assert.assertFalse((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void releaseLockFailsIfFileUnlocked() {
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        LockResult result = this.lockService.releaseLock(this.path);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.path, (Object)result.getLockInfo().getFile());
        Assert.assertEquals(null, (Object)result.getLockInfo().lockedBy());
        Assert.assertFalse((boolean)result.getLockInfo().isLocked());
    }

    @Test
    public void releaseLockUpdatesSession() {
        this.lockService.acquireLock(this.path);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"testUser");
        this.lockService.releaseLock(this.path);
        ((HttpSession)Mockito.verify((Object)this.httpSession)).setAttribute((String)Matchers.eq((Object)"uf-locks"), Matchers.any(Set.class));
    }

    private void setupRpcContext() {
        Message message = ((MessageBuildSendableWithReply)MessageBuilder.createMessage((String)"for testing").signalling().done()).getMessage();
        message.setResource("Session", (Object)this.queueSession);
        RpcContext.set((Message)message);
    }
}

