/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.backend.server.security.WebAppSettings;

public class WebAppSettingsTest {
    private String slash = File.separator;

    @Test
    public void testLastSlashIgnored() {
        WebAppSettings.get().setRootDir("/test/");
        String homeDir = WebAppSettings.get().getRootDir();
        Assert.assertEquals((Object)homeDir, (Object)(this.slash + "test"));
        WebAppSettings.get().setRootDir("c:\\test\\");
        homeDir = WebAppSettings.get().getRootDir();
        Assert.assertEquals((Object)homeDir, (Object)("c:" + this.slash + "test"));
    }

    @Test
    public void testRelativeDir() {
        WebAppSettings.get().setRootDir("test");
        File myFile = WebAppSettings.get().getFile("mydir/myfile");
        Assert.assertEquals((Object)myFile.getPath(), (Object)("test" + this.slash + "mydir" + this.slash + "myfile"));
    }
}

