/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.AuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.FileSystemAuthorizationManager;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.backend.server.security.IOSecurityAuth;
import org.uberfire.backend.server.security.IOSecurityAuthz;
import org.uberfire.backend.server.security.JAASAuthenticationService;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;
import org.uberfire.java.nio.security.SecuredFileSystemProvider;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
@Startup
public class IOServiceSecuritySetup {
    private static final Logger LOG = LoggerFactory.getLogger(IOServiceSecuritySetup.class);
    public static final String AUTH_DOMAIN_KEY = "org.uberfire.domain";
    @Inject
    @IOSecurityAuth
    private Instance<AuthenticationService> authenticationManagers;
    @Inject
    @IOSecurityAuthz
    private Instance<AuthorizationManager> authorizationManagers;

    @PostConstruct
    public void setup() {
        AuthenticationService authenticationManager;
        if (this.authenticationManagers.isUnsatisfied()) {
            String authType = System.getProperty("org.uberfire.io.auth", null);
            String domain = System.getProperty(AUTH_DOMAIN_KEY, "ApplicationRealm");
            authenticationManager = authType == null || authType.toLowerCase().equals("jaas") || authType.toLowerCase().equals("container") ? new JAASAuthenticationService(domain) : this.loadClazz(authType, AuthenticationService.class);
        } else {
            authenticationManager = (AuthenticationService)this.authenticationManagers.get();
        }
        final FileSystemAuthorizationManager authorizationManager = this.authorizationManagers.isUnsatisfied() ? new FileSystemAuthorizationManager() : (AuthorizationManager)this.authorizationManagers.get();
        FileSystemAuthorizer ioAuthorizationManager = new FileSystemAuthorizer(){

            public boolean authorize(FileSystem fs, FileSystemUser fileSystemUser) {
                return authorizationManager.authorize((Resource)new FileSystemResourceAdaptor(fs), ((UserAdapter)fileSystemUser).getWrappedUser());
            }
        };
        for (FileSystemProvider fp : FileSystemProviders.installedProviders()) {
            if (!(fp instanceof SecuredFileSystemProvider)) continue;
            SecuredFileSystemProvider sfp = (SecuredFileSystemProvider)fp;
            sfp.setAuthenticator(new FileSystemAuthenticator(){

                public FileSystemUser authenticate(String username, String password) {
                    try {
                        User result = authenticationManager.login(username, password);
                        if (result != null) {
                            return new UserAdapter(result);
                        }
                        return null;
                    }
                    catch (AuthenticationException loginFailed) {
                        LOG.warn("Login failed", (Throwable)loginFailed);
                        return null;
                    }
                }
            });
            sfp.setAuthorizer(ioAuthorizationManager);
        }
    }

    private <T> T loadClazz(String clazzName, Class<T> typeOf) {
        if (clazzName == null || clazzName.isEmpty()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            if (!typeOf.isAssignableFrom(clazz)) {
                LOG.error("Class '" + clazzName + "' is not assignable to expected type " + typeOf + ". Continuing as if no class was specified.");
                return null;
            }
            return typeOf.cast(clazz.newInstance());
        }
        catch (Exception e) {
            LOG.error("Failed to load class '" + clazzName + "' as type " + typeOf + ". Continuing as if none was specified.", (Throwable)e);
            return null;
        }
    }

    static class UserAdapter
    implements FileSystemUser {
        private final User user;

        UserAdapter(User user) {
            this.user = user;
        }

        public String getName() {
            return this.user.getIdentifier();
        }

        public User getWrappedUser() {
            return this.user;
        }
    }
}

