/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.backend.server.security.adapter.GroupAdapterAuthorizationSource;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
@Alternative
public class JAASAuthenticationService
extends GroupAdapterAuthorizationSource
implements AuthenticationService {
    public static final String DEFAULT_DOMAIN = "ApplicationRealm";
    static final String DEFAULT_ROLE_PRINCIPLE_NAME = "Roles";
    private final String rolePrincipleName = "Roles";
    private final ThreadLocal<User> userOnThisThread = new ThreadLocal();
    private final String domain;

    public JAASAuthenticationService(String domain) {
        this.domain = (String)PortablePreconditions.checkNotNull((String)"domain", (Object)domain);
    }

    public User login(String username, String password) {
        try {
            LoginContext loginContext = this.createLoginContext(username, password);
            loginContext.login();
            List<String> principals = this.loadEntitiesFromSubjectAndAdapters(username, loginContext.getSubject(), new String[]{DEFAULT_ROLE_PRINCIPLE_NAME});
            List<Role> roles = this.getRoles(principals);
            List<Group> groups = this.getGroups(principals);
            UserImpl user = new UserImpl(username, roles, groups);
            this.userOnThisThread.set((User)user);
            return user;
        }
        catch (LoginException ex) {
            throw new FailedAuthenticationException();
        }
    }

    public void logout() {
        this.userOnThisThread.remove();
    }

    public User getUser() {
        User user = this.userOnThisThread.get();
        if (user == null) {
            return User.ANONYMOUS;
        }
        return user;
    }

    public boolean isLoggedIn() {
        return this.userOnThisThread.get() != null;
    }

    LoginContext createLoginContext(String username, String password) throws LoginException {
        return new LoginContext(this.domain, new UsernamePasswordCallbackHandler(username, password));
    }

    class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public UsernamePasswordCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCB = (NameCallback)callback;
                    nameCB.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCB = (PasswordCallback)callback;
                    passwordCB.setPassword(this.password.toCharArray());
                    continue;
                }
                try {
                    Method method = callback.getClass().getMethod("setObject", Object.class);
                    method.invoke((Object)callback, this.password);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

