/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.WebAppSettings;
import org.uberfire.mvp.Command;

@WebListener
public class WebAppListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(WebAppListener.class);
    private static List<Command> onStartupCommandList = new ArrayList<Command>();
    private static List<Command> onDestroyCommandList = new ArrayList<Command>();
    private static boolean initialized = false;
    private static boolean destroyed = false;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String rootDir = servletContext.getRealPath("/");
        WebAppListener.setRootDir(rootDir);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        WebAppListener.resetRootDir();
    }

    public static synchronized void registerOnStartupCommand(Command command) {
        if (initialized) {
            command.execute();
        } else {
            onStartupCommandList.add(command);
        }
    }

    public static synchronized void registerOnDestroyCommand(Command command) {
        if (destroyed) {
            command.execute();
        } else {
            onDestroyCommandList.add(command);
        }
    }

    private static synchronized void setRootDir(String rootDir) {
        initialized = true;
        WebAppSettings.get().setRootDir(rootDir);
        logger.info("Root directory = " + rootDir);
        WebAppListener.notifyCallbacks(onStartupCommandList);
    }

    private static synchronized void resetRootDir() {
        destroyed = true;
        WebAppSettings.get().setRootDir(null);
        WebAppListener.notifyCallbacks(onDestroyCommandList);
    }

    private static void notifyCallbacks(List<Command> commandList) {
        for (Command command : commandList) {
            command.execute();
        }
    }
}

