/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.adapter;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.security.authz.adapter.GroupsAdapter;

public class GroupAdapterAuthorizationSource {
    private final ServiceLoader<GroupsAdapter> groupsAdapterServiceLoader = ServiceLoader.load(GroupsAdapter.class);

    protected List<String> loadEntitiesFromSubjectAndAdapters(String username, Subject subject, String[] rolePrincipleNames) {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            List<String> principalsFromAdapters;
            List<String> principals = this.collectEntitiesFromSubject(username, subject, rolePrincipleNames);
            if (principals != null && !principals.isEmpty()) {
                roles.addAll(principals);
            }
            if ((principalsFromAdapters = this.collectEntitiesFromAdapters(username, subject)) != null && !principalsFromAdapters.isEmpty()) {
                roles.addAll(principalsFromAdapters);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return roles;
    }

    protected List<String> collectEntitiesFromAdapters(String username, Subject subject) {
        HashSet<String> userGroups = new HashSet<String>();
        for (GroupsAdapter adapter : this.groupsAdapterServiceLoader) {
            List groupRoles = adapter.getGroups(username, (Object)subject);
            if (groupRoles == null) continue;
            for (Group group : groupRoles) {
                userGroups.add(group.getName());
            }
        }
        return new LinkedList<String>(userGroups);
    }

    protected List<String> collectEntitiesFromSubject(String username, Subject subject, String[] rolePrincipleNames) {
        ArrayList<String> roles;
        block7: {
            if (null == subject) {
                return null;
            }
            roles = new ArrayList<String>();
            try {
                Set<Principal> principals = subject.getPrincipals();
                if (principals == null) break block7;
                for (Principal p : principals) {
                    if (p instanceof java.security.acl.Group) {
                        for (String rolePrincipleName : rolePrincipleNames) {
                            if (!rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                            Enumeration groups = ((java.security.acl.Group)p).members();
                            while (groups.hasMoreElements()) {
                                Principal groupPrincipal = (Principal)groups.nextElement();
                                roles.add(groupPrincipal.getName());
                            }
                        }
                        continue;
                    }
                    roles.add(p.getName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return roles;
    }

    protected List<Role> getRoles(List<String> principals) {
        Set<Role> registeredRoles;
        if (null != principals && !principals.isEmpty() && null != (registeredRoles = RoleRegistry.get().getRegisteredRoles()) && !registeredRoles.isEmpty()) {
            LinkedList<Role> result = new LinkedList<Role>();
            for (String role : principals) {
                if (null == RoleRegistry.get().getRegisteredRole(role)) continue;
                result.add((Role)new RoleImpl(role));
            }
            return result;
        }
        return null;
    }

    protected List<Group> getGroups(List<String> principals) {
        Set<Role> registeredRoles;
        if (null != principals && !principals.isEmpty() && null != (registeredRoles = RoleRegistry.get().getRegisteredRoles()) && !registeredRoles.isEmpty()) {
            LinkedList<Group> result = new LinkedList<Group>();
            for (String role : principals) {
                if (null != RoleRegistry.get().getRegisteredRole(role)) continue;
                result.add((Group)new GroupImpl(role));
            }
            return result;
        }
        return null;
    }
}

