/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.server.WebAppListener;
import org.uberfire.backend.server.WebAppSettings;
import org.uberfire.backend.server.authz.AuthorizationPolicyMarshaller;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;

@Startup
@ApplicationScoped
public class AuthorizationPolicyDeployer {
    private Logger logger = LoggerFactory.getLogger(AuthorizationPolicyDeployer.class);
    private AuthorizationPolicyStorage authzPolicyStorage;
    private PermissionManager permissionManager;
    private Event<AuthorizationPolicyDeployedEvent> deployedEvent;

    public AuthorizationPolicyDeployer() {
    }

    @Inject
    public AuthorizationPolicyDeployer(AuthorizationPolicyStorage authzPolicyStorage, PermissionManager permissionManager, Event<AuthorizationPolicyDeployedEvent> deployedEvent) {
        this.authzPolicyStorage = authzPolicyStorage;
        this.permissionManager = permissionManager;
        this.deployedEvent = deployedEvent;
    }

    @PostConstruct
    public void init() {
        WebAppListener.registerOnStartupCommand(this::deployPolicy);
    }

    public void deployPolicy() {
        Path policyDir = this.getPolicyDir();
        this.deployPolicy(policyDir);
    }

    public Path getPolicyDir() {
        String rootDir = WebAppSettings.get().getRootDir();
        return Paths.get(rootDir, "WEB-INF", "classes");
    }

    public void deployPolicy(Path policyDir) {
        if (policyDir != null) {
            AuthorizationPolicy policy = this.authzPolicyStorage.loadPolicy();
            if (policy == null) {
                policy = this.loadPolicy(policyDir);
                this.authzPolicyStorage.savePolicy(policy);
                this.logger.info("Security policy deployed");
                for (Role role : policy.getRoles()) {
                    RoleRegistry.get().registerRole(role.getName());
                }
                this.deployedEvent.fire((Object)new AuthorizationPolicyDeployedEvent(policy));
            } else {
                this.logger.info("Security policy active");
            }
            this.permissionManager.setAuthorizationPolicy(policy);
        } else {
            this.logger.info("Security policy not defined");
        }
    }

    public AuthorizationPolicy loadPolicy(Path policyDir) {
        AuthorizationPolicyBuilder builder = this.permissionManager.newAuthorizationPolicy();
        AuthorizationPolicyMarshaller marshaller = new AuthorizationPolicyMarshaller();
        if (policyDir != null) {
            try {
                Files.list(policyDir).filter(this::isPolicyFile).forEach(p -> this.loadPolicyFile(builder, marshaller, (Path)p));
            }
            catch (IOException e) {
                this.logger.warn("Error loading security policy files", (Throwable)e);
            }
        }
        return builder.build();
    }

    public boolean isPolicyFile(Path p) {
        String fileName = p.getName(p.getNameCount() - 1).toString();
        return fileName.equals("security-policy.properties") || fileName.startsWith("security-module-");
    }

    public void loadPolicyFile(AuthorizationPolicyBuilder builder, AuthorizationPolicyMarshaller marshaller, Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Properties p = new Properties();
            p.load(reader);
            marshaller.read(builder, p);
        }
        catch (IOException e) {
            this.logger.error("Security policy load error", (Throwable)e);
        }
    }
}

