/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.util.concurrent.ExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugin.AbstractGwtRuntimePluginTest;
import org.uberfire.backend.server.plugin.GwtRuntimePluginLoader;
import org.uberfire.backend.server.plugin.GwtRuntimePluginWatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class GwtRuntimePluginWatcherTest
extends AbstractGwtRuntimePluginTest {
    @InjectMocks
    private GwtRuntimePluginWatcher pluginWatcher;
    @Mock
    private GwtRuntimePluginLoader pluginLoader;
    @Mock
    private ExecutorService executor;

    @After
    public void tearDown() {
        this.pluginWatcher.stop();
    }

    @Test
    public void startSubmitsWatcherThread() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginLoader);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void startDoesNotSubmitWatcherThreadIfPluginDirDoesNotExist() throws Exception {
        this.pluginWatcher.start(this.pluginDir + "invalid", this.executor, this.pluginLoader);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).submit((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void startOnlyOnce() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginLoader);
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginLoader);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void stopEndsWatcherThread() throws Exception {
        this.pluginWatcher.start(this.pluginDir, this.executor, this.pluginLoader);
        Assert.assertTrue((boolean)this.pluginWatcher.active);
        this.pluginWatcher.stop();
        Assert.assertFalse((boolean)this.pluginWatcher.active);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).shutdown();
    }
}

