/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.FileSystemFactory;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public final class Paths {
    private static Map<org.uberfire.java.nio.file.FileSystem, FileSystem> cache = new HashMap<org.uberfire.java.nio.file.FileSystem, FileSystem>();

    public static org.uberfire.backend.vfs.Path convert(final Path path) {
        if (path == null) {
            return null;
        }
        if (path.getFileName() == null) {
            return PathFactory.newPath((String)"/", (String)path.toUri().toString(), (Map)new HashMap<String, Object>(1){
                {
                    super(x0);
                    this.put(PathFactory.VERSION_PROPERTY, path.getFileSystem().supportedFileAttributeViews().contains("version"));
                }
            });
        }
        return PathFactory.newPath((String)path.getFileName().toString(), (String)path.toUri().toString(), (Map)new HashMap<String, Object>(1){
            {
                super(x0);
                this.put(PathFactory.VERSION_PROPERTY, path.getFileSystem().supportedFileAttributeViews().contains("version"));
            }
        });
    }

    public static Path convert(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        return org.uberfire.java.nio.file.Paths.get((URI)URI.create(path.toURI()));
    }

    public static FileSystem convert(org.uberfire.java.nio.file.FileSystem fs) {
        if (!cache.containsKey(fs)) {
            HashMap<String, String> roots = new HashMap<String, String>();
            for (Path root : fs.getRootDirectories()) {
                roots.put(root.toUri().toString(), root.getFileName() == null ? "/" : root.getFileName().toString());
            }
            cache.put(fs, FileSystemFactory.newFS(roots, (Set)fs.supportedFileAttributeViews()));
        }
        return cache.get(fs);
    }

    public static String readLockedBy(org.uberfire.backend.vfs.Path path) {
        Path lock = Paths.convert(PathFactory.newLock((org.uberfire.backend.vfs.Path)path));
        if (!Files.exists((Path)lock, (LinkOption[])new LinkOption[0])) {
            return null;
        }
        return new String(Files.readAllBytes((Path)lock));
    }

    public static boolean isLock(org.uberfire.backend.vfs.Path path) {
        return path.toURI().endsWith(".ulock");
    }
}

