/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.security.JAASAuthenticationService;
import org.uberfire.backend.server.security.RoleRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class JAASAuthenticationServiceTest {
    private JAASAuthenticationService tested;

    @Before
    public void setup() {
        this.tested = (JAASAuthenticationService)Mockito.spy((Object)new JAASAuthenticationService("ApplicationRealm"));
    }

    @Test
    public void testNoLogin() throws Exception {
        Assert.assertEquals((Object)User.ANONYMOUS, (Object)this.tested.getUser());
    }

    @Test
    public void testGetAnnonymous() throws Exception {
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testLogin() throws Exception {
        String username = "user1";
        String password = "password1";
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(Matchers.anyString(), Matchers.anyString());
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)1L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
    }

    @Test
    public void testLoginNoPrincipal() throws Exception {
        String username = "user1";
        String password = "password1";
        Subject subject = new Subject();
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(Matchers.anyString(), Matchers.anyString());
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)0L, (long)user.getRoles().size());
        Assert.assertEquals((long)0L, (long)user.getGroups().size());
    }

    @Test
    public void testLoginSubjectGroups() throws Exception {
        String username = "user1";
        String password = "password1";
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1");
        Group aclGroup = (Group)Mockito.mock(Group.class);
        ((Group)Mockito.doReturn((Object)"Roles").when((Object)aclGroup)).getName();
        Set<Principal> aclGroups = this.mockPrincipals("g1", "g2");
        Enumeration<Principal> aclGroupsEnum = Collections.enumeration(aclGroups);
        ((Group)Mockito.doReturn(aclGroupsEnum).when((Object)aclGroup)).members();
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        subject.getPrincipals().add((Principal)aclGroup);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(Matchers.anyString(), Matchers.anyString());
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)3L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g2")));
    }

    @Test
    public void testLoggedIn() throws Exception {
        String username = "user1";
        String password = "password1";
        RoleRegistry.get().registerRole("admin");
        Set<Principal> principals = this.mockPrincipals("admin");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(Matchers.anyString(), Matchers.anyString());
        this.tested.login(username, password);
        Assert.assertTrue((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testGetUser() throws Exception {
        String username = "user1";
        String password = "password1";
        RoleRegistry.get().registerRole("admin");
        Set<Principal> principals = this.mockPrincipals("admin");
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.getSubject()).thenReturn((Object)subject);
        ((JAASAuthenticationService)Mockito.doReturn((Object)loginContext).when((Object)this.tested)).createLoginContext(Matchers.anyString(), Matchers.anyString());
        User user = this.tested.login(username, password);
        User user1 = this.tested.getUser();
        Assert.assertEquals((Object)user, (Object)user1);
    }

    private Set<Principal> mockPrincipals(String ... names) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String name : names) {
            Principal p1 = (Principal)Mockito.mock(Principal.class);
            Mockito.when((Object)p1.getName()).thenReturn((Object)name);
            principals.add(p1);
        }
        return principals;
    }
}

