/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.util.concurrent.ExecutorService;
import org.jboss.errai.cdi.server.scripts.ScriptRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.plugin.AbstractGwtRuntimePluginTest;
import org.uberfire.backend.server.plugin.GwtRuntimePluginLoader;
import org.uberfire.backend.server.plugin.GwtRuntimePluginManager;
import org.uberfire.backend.server.plugin.GwtRuntimePluginWatcher;
import org.uberfire.backend.server.plugin.PluginRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class GwtRuntimePluginManagerTest
extends AbstractGwtRuntimePluginTest {
    @InjectMocks
    private GwtRuntimePluginManager manager;
    @Mock
    private GwtRuntimePluginWatcher pluginWatcher;
    @Mock
    private GwtRuntimePluginLoader pluginLoader;
    @Mock
    private ScriptRegistry scriptRegistry;

    @Test
    public void initPluginLoader() throws Exception {
        this.manager.init(this.contextRootDir, this.pluginDir);
        ((GwtRuntimePluginLoader)Mockito.verify((Object)this.pluginLoader, (VerificationMode)Mockito.times((int)1))).init((String)Matchers.eq((Object)this.contextRootDir), (String)Matchers.eq((Object)this.pluginDir), (String)Matchers.eq((Object)this.pluginDeploymentDir), (PluginRegistry)Matchers.any(PluginRegistry.class));
    }

    @Test
    public void initStartsWatcher() throws Exception {
        this.manager.init(this.contextRootDir, this.pluginDir);
        ((GwtRuntimePluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).start((String)Matchers.eq((Object)this.pluginDir), (ExecutorService)Matchers.any(ExecutorService.class), (GwtRuntimePluginLoader)Matchers.eq((Object)this.pluginLoader));
    }

    @Test
    public void shutdownStopsWatcher() throws Exception {
        this.manager.shutDown();
        ((GwtRuntimePluginWatcher)Mockito.verify((Object)this.pluginWatcher, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void shutDownRemovesScripts() throws Exception {
        this.manager.shutDown();
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry, (VerificationMode)Mockito.times((int)1))).removeScripts("UF");
    }

    @Test
    public void findPluginDeploymentDir() throws Exception {
        String pluginDeploymentDir = this.manager.findPluginDeploymentDir(this.contextRootDir);
        Assert.assertEquals((Object)this.pluginDeploymentDir, (Object)pluginDeploymentDir);
    }

    @Test
    public void pluginRegistryUsesErraiScriptRegistry() throws Exception {
        this.manager.init(this.contextRootDir, this.pluginDir);
        ArgumentCaptor pluginRegistry = ArgumentCaptor.forClass(PluginRegistry.class);
        ((GwtRuntimePluginLoader)Mockito.verify((Object)this.pluginLoader, (VerificationMode)Mockito.times((int)1))).init((String)Matchers.eq((Object)this.contextRootDir), (String)Matchers.eq((Object)this.pluginDir), (String)Matchers.eq((Object)this.pluginDeploymentDir), (PluginRegistry)pluginRegistry.capture());
        PluginRegistry registry = (PluginRegistry)pluginRegistry.getValue();
        registry.add("test", "url");
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry)).addScript("UF", "url");
        Assert.assertTrue((boolean)registry.isRegistered("test"));
        registry.remove("test", "url");
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry)).removeScript("UF", "url");
        Assert.assertFalse((boolean)registry.isRegistered("test"));
        registry.add("test", "url");
        Assert.assertTrue((boolean)registry.isRegistered("test"));
        registry.removeAll();
        ((ScriptRegistry)Mockito.verify((Object)this.scriptRegistry)).removeScripts("UF");
        Assert.assertFalse((boolean)registry.isRegistered("test"));
    }
}

