/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cluster;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.cluster.ClusterServiceFactoryProducer;
import org.uberfire.commons.cluster.ClusterServiceFactory;

public class ClusterServiceFactoryProducerTest {
    @Test
    public void testClusterNotAvailable() {
        ClusterServiceFactoryProducer factoryProducer = new ClusterServiceFactoryProducer(){

            ClusterServiceFactory buildFactory() {
                return null;
            }
        };
        Assert.assertNull((Object)factoryProducer.clusterServiceFactory());
    }

    @Test
    public void testClusterInitializedBeforeAnyUse() {
        final ClusterServiceFactory clusterServiceFactory = (ClusterServiceFactory)Mockito.mock(ClusterServiceFactory.class);
        ClusterServiceFactoryProducer factoryProducer = new ClusterServiceFactoryProducer(){

            ClusterServiceFactory buildFactory() {
                return clusterServiceFactory;
            }
        };
        ClusterServiceFactory factory = factoryProducer.clusterServiceFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals((Object)clusterServiceFactory, (Object)factory);
        ((ClusterServiceFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).build(null);
    }
}

