/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.plugins.PluginUtils;
import org.uberfire.backend.server.plugins.engine.PluginManager;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@Service
@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class PluginService {
    private static PluginService instance;
    private PluginManager pluginManager;

    public PluginService() {
    }

    @Inject
    public PluginService(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @PostConstruct
    private void startUp() {
        instance = this;
    }

    public static PluginService getInstance() {
        if (instance == null) {
            throw new IllegalStateException(PluginService.class.getName() + " was not initialized on startup");
        }
        return instance;
    }

    public void init(ServletContext servletContext) {
        String contextRootDir = this.getContextRootDir(servletContext);
        String pluginDir = this.getPlugins(servletContext, "plugins");
        if (contextRootDir != null && pluginDir != null) {
            this.pluginManager.init(contextRootDir, pluginDir);
        }
    }

    String getPlugins(ServletContext servletContext, String plugins) {
        return PluginUtils.getRealPath(servletContext, plugins);
    }

    String getContextRootDir(ServletContext servletContext) {
        return this.getPlugins(servletContext, File.separator);
    }
}

