/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.uberfire.backend.server.util.TextUtil;

public class TextUtilTest
extends TestCase {
    private static final String BASE = "dUMmY";
    String userNameIllegalChars = "\u00aa\u00ba\\!|\"@\u00b7#$%&\u00ac/()=?'\u00bf\u00a1\u20ac^`[*+]\u00a8\u00b4{}<>,;:_~ .-";
    String repoNameIllegalChars = "\u00aa\u00ba\\!|\"@\u00b7#$%&\u00ac/()=?'\u00bf\u00a1\u20ac^`[*+]\u00a8\u00b4{}<>,;:_~ ";
    Map<Character, Character> additionalIllegal = new HashMap<Character, Character>();
    private StringBuilder sb = new StringBuilder("dUMmY");

    protected void setUp() throws Exception {
        this.additionalIllegal.put(Character.valueOf('\u00f1'), Character.valueOf('n'));
        this.additionalIllegal.put(Character.valueOf('\u00d1'), Character.valueOf('N'));
        this.additionalIllegal.put(Character.valueOf('\u00e7'), Character.valueOf('c'));
        this.additionalIllegal.put(Character.valueOf('\u00c7'), Character.valueOf('C'));
        this.additionalIllegal.put(Character.valueOf('\u00e1'), Character.valueOf('a'));
        this.additionalIllegal.put(Character.valueOf('\u00e0'), Character.valueOf('a'));
        this.additionalIllegal.put(Character.valueOf('\u00e4'), Character.valueOf('a'));
        this.additionalIllegal.put(Character.valueOf('\u00c1'), Character.valueOf('A'));
        this.additionalIllegal.put(Character.valueOf('\u00c0'), Character.valueOf('A'));
        this.additionalIllegal.put(Character.valueOf('\u00c4'), Character.valueOf('A'));
    }

    public void testNormalizeUserName() {
        for (int i = 0; i < this.userNameIllegalChars.length(); ++i) {
            int index = 0;
            TextUtilTest.assertEquals((String)BASE, (String)TextUtil.normalizeUserName((String)this.sb.insert(index, this.userNameIllegalChars.charAt(i)).toString()));
            this.sb.deleteCharAt(index);
            index = BASE.length() - 3;
            TextUtilTest.assertEquals((String)BASE, (String)TextUtil.normalizeUserName((String)this.sb.insert(index, this.userNameIllegalChars.charAt(i)).toString()));
            this.sb.deleteCharAt(index);
            index = BASE.length() - 1;
            TextUtilTest.assertEquals((String)BASE, (String)TextUtil.normalizeUserName((String)this.sb.insert(index, this.userNameIllegalChars.charAt(i)).toString()));
            this.sb.deleteCharAt(index);
        }
        StringBuilder expected = new StringBuilder(BASE);
        for (Map.Entry<Character, Character> entry : this.additionalIllegal.entrySet()) {
            int index = 0;
            TextUtilTest.assertEquals((String)expected.insert(index, entry.getValue()).toString(), (String)TextUtil.normalizeUserName((String)this.sb.insert(index, entry.getKey()).toString()));
            this.sb.deleteCharAt(index);
            expected.deleteCharAt(index);
            index = BASE.length() - 3;
            TextUtilTest.assertEquals((String)expected.insert(index, entry.getValue()).toString(), (String)TextUtil.normalizeUserName((String)this.sb.insert(index, entry.getKey()).toString()));
            this.sb.deleteCharAt(index);
            expected.deleteCharAt(index);
            index = BASE.length() - 1;
            TextUtilTest.assertEquals((String)expected.insert(index, entry.getValue()).toString(), (String)TextUtil.normalizeUserName((String)this.sb.insert(index, entry.getKey()).toString()));
            this.sb.deleteCharAt(index);
            expected.deleteCharAt(index);
        }
    }

    public void testNormalizeRepositoryName() {
        for (int i = 0; i < this.repoNameIllegalChars.length(); ++i) {
            int index = 0;
            TextUtilTest.assertEquals((String)BASE, (String)TextUtil.normalizeRepositoryName((String)this.sb.insert(index, this.repoNameIllegalChars.charAt(i)).toString()));
            this.sb.deleteCharAt(index);
            index = BASE.length() - 3;
            TextUtilTest.assertEquals((String)BASE, (String)TextUtil.normalizeRepositoryName((String)this.sb.insert(index, this.repoNameIllegalChars.charAt(i)).toString()));
            this.sb.deleteCharAt(index);
            index = BASE.length() - 1;
            TextUtilTest.assertEquals((String)BASE, (String)TextUtil.normalizeRepositoryName((String)this.sb.insert(index, this.repoNameIllegalChars.charAt(i)).toString()));
            this.sb.deleteCharAt(index);
        }
        StringBuilder expected = new StringBuilder(BASE);
        for (Map.Entry<Character, Character> entry : this.additionalIllegal.entrySet()) {
            int index = 0;
            TextUtilTest.assertEquals((String)expected.insert(index, entry.getValue()).toString(), (String)TextUtil.normalizeRepositoryName((String)this.sb.insert(index, entry.getKey()).toString()));
            this.sb.deleteCharAt(index);
            expected.deleteCharAt(index);
            index = BASE.length() - 3;
            TextUtilTest.assertEquals((String)expected.insert(index, entry.getValue()).toString(), (String)TextUtil.normalizeRepositoryName((String)this.sb.insert(index, entry.getKey()).toString()));
            this.sb.deleteCharAt(index);
            expected.deleteCharAt(index);
            index = BASE.length() - 1;
            TextUtilTest.assertEquals((String)expected.insert(index, entry.getValue()).toString(), (String)TextUtil.normalizeRepositoryName((String)this.sb.insert(index, entry.getKey()).toString()));
            this.sb.deleteCharAt(index);
            expected.deleteCharAt(index);
        }
        String strInput = "";
        String strExpected = "";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "_{`";
        strExpected = "";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = ".";
        strExpected = "";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "-";
        strExpected = "";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "...";
        strExpected = "";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "---";
        strExpected = "";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "..d.";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = ".d..";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "--d-";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "-d--";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "..d..";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = ".-d..";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = ".d-..";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "--d--.";
        strExpected = "d";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d---f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d...f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d----f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d-f";
        strExpected = "d-f";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d.f";
        strExpected = "d.f";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d.-f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d.-.f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d-.-f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d-.f";
        strExpected = "df";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "d..-.-B'.--..+-_--\u00e7-..f";
        strExpected = "dBcf";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "m\"y-t@\u00ebs#t'.re{p'o-n:a;m,e";
        strExpected = "my-test.repo-name";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = "-m\"y-t@\u00ebs#t'.re{p'o-n:a;m,e-";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
        strInput = ".m\"y-t@\u00ebs#t'.re{p'o-n:a;m,e.";
        TextUtilTest.assertEquals((String)strExpected, (String)TextUtil.normalizeRepositoryName((String)strInput));
    }
}

