/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.backend.server.WebAppSettings;

public class WebAppSettingsTest {
    String slash = FileSystems.getDefault().getSeparator();

    @Test
    public void testLastSlashIgnored() {
        WebAppSettings.get().setRootDir("/test/");
        String homeDir = WebAppSettings.get().getRootDir();
        Assert.assertEquals((Object)homeDir, (Object)(this.slash + "test"));
        WebAppSettings.get().setRootDir("c:\\test\\");
        homeDir = WebAppSettings.get().getRootDir();
        Assert.assertEquals((Object)homeDir, (Object)("c:" + this.slash + "test"));
    }

    @Test
    public void testRelativeDir() {
        WebAppSettings.get().setRootDir("test");
        Path myFile = WebAppSettings.get().getAbsolutePath(new String[]{"mydir", "myfile"});
        Assert.assertEquals((Object)myFile, (Object)Paths.get("test", "mydir", "myfile"));
    }

    @Test
    public void testEmptyDir() {
        WebAppSettings.get().setRootDir(null);
        Path myDir = WebAppSettings.get().getAbsolutePath(new String[]{"mydir"});
        Assert.assertNull((Object)myDir);
    }
}

