/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.security.authz.adapter.GroupsAdapter;

@ApplicationScoped
public class WebSphereGroupsAdapter
implements GroupsAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSphereGroupsAdapter.class);
    private Object registry;

    public WebSphereGroupsAdapter() {
        try {
            this.registry = InitialContext.doLookup("UserRegistry");
        }
        catch (NamingException e) {
            logger.info("Unable to look up UserRegistry in JNDI under key 'UserRegistry', disabling websphere adapter");
        }
    }

    public List<Group> getGroups(String principal, Object subject) {
        if (this.registry == null) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            Method method = this.registry.getClass().getMethod("getGroupsForUser", String.class);
            List rolesIn = (List)method.invoke(this.registry, principal);
            if (rolesIn != null) {
                for (Object o : rolesIn) {
                    groups.add((Group)new GroupImpl(o.toString()));
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to get groups from registry due to {}", (Object)e.getMessage(), (Object)e);
        }
        return groups;
    }
}

