/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.object;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.jboss.errai.marshalling.server.ServerMarshalling;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class ObjectStorageImpl
implements ObjectStorage {
    private IOService ioService;
    private FileSystem fileSystem;

    @Inject
    public ObjectStorageImpl(@Named(value="configIO") IOService ioService) {
        this.ioService = ioService;
    }

    @Override
    public void init(URI rootURI) {
        this.initializeMarshaller();
        this.initializeFileSystem(rootURI);
    }

    @Override
    public boolean exists(String path) {
        Path fsPath = this.fileSystem.getPath(path, new String[0]);
        try {
            return this.ioService.exists(fsPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T read(String path) {
        Path fsPath = this.fileSystem.getPath(path, new String[0]);
        try {
            if (this.ioService.exists(fsPath)) {
                String content = this.ioService.readAllString(fsPath);
                return (T)ServerMarshalling.fromJSON((String)content);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public <T> void write(String path, T value) {
        this.write(path, value, true);
    }

    @Override
    public <T> void write(String path, T value, boolean lock) {
        try {
            if (lock) {
                this.ioService.startBatch(this.fileSystem);
            }
            Path fsPath = this.fileSystem.getPath(path, new String[0]);
            String content = ServerMarshalling.toJSON(value);
            this.ioService.write(fsPath, content, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (lock) {
                this.ioService.endBatch();
            }
        }
    }

    @Override
    public void delete(String path) {
        this.ioService.deleteIfExists(this.fileSystem.getPath(path, new String[0]), new DeleteOption[0]);
    }

    @Override
    public Path getPath(String first, String ... paths) {
        return this.fileSystem.getPath(first, paths);
    }

    @Override
    public void close() {
        this.fileSystem.close();
        this.fileSystem.dispose();
    }

    private void initializeMarshaller() {
        MappingContextSingleton.get();
    }

    private void initializeFileSystem(URI rootURI) {
        try {
            this.fileSystem = this.ioService.newFileSystem(rootURI, (Map)new HashMap<String, Object>(){
                {
                    this.put("init", Boolean.TRUE);
                    this.put("internal", Boolean.TRUE);
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fileSystem = this.ioService.getFileSystem(rootURI);
        }
    }
}

