/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.elytron.ElytronIdentityHelper;

@ApplicationScoped
@Alternative
public class ElytronAuthenticationService
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(ElytronAuthenticationService.class);
    private final ElytronIdentityHelper elytronIdentityHelper;
    private final ThreadLocal<User> userOnThisThread = new ThreadLocal();

    @Inject
    public ElytronAuthenticationService(ElytronIdentityHelper elytronIdentityHelper) {
        this.elytronIdentityHelper = elytronIdentityHelper;
    }

    public User login(String username, String password) {
        try {
            User user = this.elytronIdentityHelper.getIdentity(username, password);
            this.userOnThisThread.set(user);
            return user;
        }
        catch (Exception ex) {
            logger.debug("Cannot login user '{}':", (Object)username, (Object)ex);
            throw new FailedAuthenticationException();
        }
    }

    public boolean isLoggedIn() {
        return this.userOnThisThread.get() != null;
    }

    public void logout() {
        this.userOnThisThread.remove();
    }

    public User getUser() {
        User user = this.userOnThisThread.get();
        if (user == null) {
            return User.ANONYMOUS;
        }
        return user;
    }
}

