/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Generated;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import javax.inject.Named;
import org.uberfire.workbench.model.PerspectiveDefinition;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.mvp.AbstractTemplateWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;

import org.uberfire.mvp.PlaceRequest;

import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.workbench.TemplatePanelDefinitionImpl;
import org.uberfire.client.workbench.TemplatePerspectiveDefinitionImpl;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PanelType;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@Dependent
@Generated("org.uberfire.annotations.processors.WorkbenchPerspectiveProcessor")
@Named("AnotherPerspective")
/*
 * WARNING! This class is generated. Do not modify.
 */
public class AnotherPerspectiveActivity extends  AbstractTemplateWorkbenchPerspectiveActivity  {

    private static final Collection<String> ROLES = Collections.emptyList();

    private static final Collection<String> TRAITS = Collections.emptyList();

    @Inject
    private AnotherPerspective realPresenter;

    @Inject
    //Constructor injection for testing
    public AnotherPerspectiveActivity(final PlaceManager placeManager) {
        super( placeManager );
    }

    @Override
    public String getIdentifier() {
        return "AnotherPerspective";
    }

    @Override
    public Collection<String> getRoles() {
        return ROLES;
    }

    @Override
    public Collection<String> getTraits() {
        return TRAITS;
    }

    @Override
    public String getSignatureId() {
        return "org.uberfire.client.AnotherPerspectiveActivity";
    }
    @Override
    public Widget getRealPresenterWidget( ) {
      return realPresenter.asWidget();
    }

    @Override
    public void setWidget( String fieldName,
        Widget widget ) {

        if ( fieldName.equalsIgnoreCase( "homeScreen" ) ) {
            realPresenter.homeScreen.clear();
            realPresenter.homeScreen.add( widget.asWidget() );
        }
    }

    @Perspective
    public PerspectiveDefinition getPerspective() {
        final PerspectiveDefinition p = new TemplatePerspectiveDefinitionImpl( this,"homeScreen", getClass().getName() );
        PanelDefinition panelDefinition = new TemplatePanelDefinitionImpl( this, PanelType.MULTI_TAB , "homeScreen"  );
            panelDefinition.addPart(
            new PartDefinitionImpl(new DefaultPlaceRequest( "HomeScreen" ) ) );
            panelDefinition.addPart(
            new PartDefinitionImpl(new DefaultPlaceRequest( "MoodScreen" ) ) );
        p.getRoot().appendChild( panelDefinition );

        return p;
    }

}
