/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.DeleteRestrictor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class DeleteServiceImpl
implements DeleteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Instance<DeleteRestrictor> deleteRestrictorBeans;

    public void delete(Path path, String comment) {
        LOGGER.info("User:" + this.identity.getIdentifier() + " deleting file [" + path.getFileName() + "]");
        this.checkRestrictions(path);
        try {
            this.deletePath(path, comment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteIfExists(Collection<Path> paths, String comment) {
        try {
            this.startBatch(paths);
            for (Path path : paths) {
                LOGGER.info("User:" + this.identity.getIdentifier() + " deleting file (if exists) [" + path.getFileName() + "]");
                this.checkRestrictions(path);
                this.deletePathIfExists(path, comment);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endBatch(paths);
        }
    }

    public boolean hasRestriction(Path path) {
        for (DeleteRestrictor deleteRestrictor : this.getDeleteRestrictors()) {
            PathOperationRestriction deleteRestriction = deleteRestrictor.hasRestriction(path);
            if (deleteRestriction == null) continue;
            return true;
        }
        return false;
    }

    private void checkRestrictions(Path path) {
        for (DeleteRestrictor deleteRestrictor : this.getDeleteRestrictors()) {
            PathOperationRestriction deleteRestriction = deleteRestrictor.hasRestriction(path);
            if (deleteRestriction == null) continue;
            throw new RuntimeException(deleteRestriction.getMessage(path));
        }
    }

    void deletePath(Path path, String comment) {
        this.ioService.delete(Paths.convert((Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment)});
    }

    void deletePathIfExists(Path path, String comment) {
        this.ioService.deleteIfExists(Paths.convert((Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getIdentifier(), null, comment), StandardDeleteOption.NON_EMPTY_DIRECTORIES});
    }

    void startBatch(Collection<Path> paths) {
        if (paths.size() > 1) {
            this.ioService.startBatch(Paths.convert((Path)paths.iterator().next()).getFileSystem());
        }
    }

    void endBatch(Collection<Path> paths) {
        if (paths.size() > 1) {
            this.ioService.endBatch();
        }
    }

    Iterable<DeleteRestrictor> getDeleteRestrictors() {
        return this.deleteRestrictorBeans;
    }
}

