/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.file.SavePopUp;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.ParameterizedCommand;

public class RestorePopup {
    @Inject
    private BusyIndicatorView busyIndicatorView;
    @Inject
    private Caller<VersionService> versionService;
    @Inject
    private Event<RestoreEvent> restoreEvent;
    @Inject
    private RestoreUtil restoreUtil;

    public void show(final ObservablePath currentPath, final String currentVersionRecordUri) {
        new SavePopUp(new ParameterizedCommand<String>(){

            public void execute(String comment) {
                RestorePopup.this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Restoring());
                ((VersionService)RestorePopup.this.versionService.call(RestorePopup.this.getRestorationSuccessCallback(currentVersionRecordUri), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RestorePopup.this.busyIndicatorView))).restore((Path)currentPath, comment);
            }
        }).show();
    }

    private RemoteCallback<Path> getRestorationSuccessCallback(final String currentVersionRecordUri) {
        return new RemoteCallback<Path>(){

            public void callback(Path restored) {
                RestorePopup.this.busyIndicatorView.hideBusyIndicator();
                RestorePopup.this.restoreEvent.fire((Object)new RestoreEvent(RestorePopup.this.restoreUtil.createObservablePath(restored, currentVersionRecordUri)));
            }
        };
    }
}

