/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathSupport;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.file.SavePopUp;
import org.uberfire.mvp.ParameterizedCommand;

public class SaveOperationService {
    public void save(final Path path, final ParameterizedCommand<String> saveCommand) {
        PortablePreconditions.checkNotNull((String)"command", saveCommand);
        final SaveOperationNotifier notifier = (SaveOperationNotifier)IOC.getBeanManager().lookupBean(SaveOperationNotifier.class, new Annotation[0]).getInstance();
        ParameterizedCommand<String> wrappedSaveCommand = new ParameterizedCommand<String>(){

            public void execute(String parameter) {
                saveCommand.execute((Object)parameter);
                notifier.notify(path);
            }
        };
        if (PathSupport.isVersioned((Path)path)) {
            new SavePopUp(wrappedSaveCommand).show();
        } else {
            wrappedSaveCommand.execute((Object)"");
        }
    }

    @ApplicationScoped
    public static class SaveOperationNotifier {
        @Inject
        private Event<SaveInProgressEvent> saveInProgressEvent;

        public void notify(Path path) {
            this.saveInProgressEvent.fire((Object)new SaveInProgressEvent(path));
        }
    }
}

