/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import com.github.gwtbootstrap.client.ui.DropdownButton;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButtonView;
import org.uberfire.ext.editor.commons.client.history.VersionMenuItemLabel;
import org.uberfire.ext.editor.commons.client.history.ViewAllLabel;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;

public class VersionMenuDropDownButtonViewImpl
extends DropdownButton
implements VersionMenuDropDownButtonView {
    private VersionMenuDropDownButtonView.Presenter presenter;

    public VersionMenuDropDownButtonViewImpl() {
        super(CommonConstants.INSTANCE.LatestVersion());
        this.setRightDropdown(true);
        this.getTriggerWidget().addStyleName("btn-mini");
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VersionMenuDropDownButtonViewImpl.this.presenter.onMenuOpening();
            }
        });
    }

    @Override
    public void setPresenter(VersionMenuDropDownButtonView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addViewAllLabel(int index, Command command) {
        this.add((Widget)new ViewAllLabel(index, command));
    }

    @Override
    public void setTextToVersion(int versionIndex) {
        this.setText(CommonConstants.INSTANCE.Version(versionIndex));
    }

    @Override
    public void setTextToLatest() {
        this.setText(CommonConstants.INSTANCE.LatestVersion());
    }

    @Override
    public void addLabel(VersionRecord versionRecord, boolean isSelected, int versionIndex) {
        VersionMenuItemLabel widget = new VersionMenuItemLabel(versionRecord, versionIndex, isSelected, new Callback<VersionRecord>(){

            public void callback(VersionRecord result) {
                VersionMenuDropDownButtonViewImpl.this.presenter.onVersionRecordSelected(result);
            }
        });
        widget.setWidth("400px");
        this.add((Widget)widget);
    }

    public boolean isEnabled() {
        return this.getTriggerWidget().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getTriggerWidget().setEnabled(enabled);
    }
}

