/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.CopyPopup;
import org.uberfire.ext.editor.commons.client.file.DeletePopup;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.RenamePopup;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.RestoreVersionCommandProvider;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class BasicFileMenuBuilderImpl
implements BasicFileMenuBuilder {
    @Inject
    private RestoreVersionCommandProvider restoreVersionCommandProvider;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    private Command saveCommand = null;
    private MenuItem saveMenuItem;
    private Command deleteCommand = null;
    private MenuItem deleteMenuItem;
    private Command renameCommand = null;
    private MenuItem renameMenuItem;
    private Command copyCommand = null;
    private Command validateCommand = null;
    private Command restoreCommand = null;
    private MenuItem restoreMenuItem;
    private List<Pair<String, Command>> otherCommands = new ArrayList<Pair<String, Command>>();
    private List<MenuItem> topLevelMenus = new ArrayList<MenuItem>();
    private List<MenuItem> menuItemsSyncedWithLockState = new ArrayList<MenuItem>();

    @Override
    public BasicFileMenuBuilder addSave(MenuItem menuItem) {
        this.saveMenuItem = menuItem;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addSave(Command command) {
        this.saveCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addDelete(final Path path, final Caller<? extends SupportsDelete> deleteCaller) {
        return this.addDelete(new Command(){

            public void execute() {
                DeletePopup popup = new DeletePopup(new ParameterizedCommand<String>(){

                    public void execute(String comment) {
                        BasicFileMenuBuilderImpl.this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Deleting());
                        ((SupportsDelete)deleteCaller.call(BasicFileMenuBuilderImpl.this.getDeleteSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)BasicFileMenuBuilderImpl.this.busyIndicatorView))).delete(path, comment);
                    }
                });
                popup.show();
            }
        });
    }

    private RemoteCallback<Void> getDeleteSuccessCallback() {
        return new RemoteCallback<Void>(){

            public void callback(Void response) {
                BasicFileMenuBuilderImpl.this.busyIndicatorView.hideBusyIndicator();
                BasicFileMenuBuilderImpl.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully()));
            }
        };
    }

    @Override
    public BasicFileMenuBuilder addDelete(Command command) {
        this.deleteCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addRename(Command command) {
        this.renameCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addRename(final Path path, final Caller<? extends SupportsRename> renameCaller) {
        return this.addRename(new Command(){

            public void execute() {
                RenamePopup popup = new RenamePopup(path, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        BasicFileMenuBuilderImpl.this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Renaming());
                        ((SupportsRename)renameCaller.call(BasicFileMenuBuilderImpl.this.getRenameSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)BasicFileMenuBuilderImpl.this.busyIndicatorView))).rename(path, details.getNewFileName(), details.getCommitMessage());
                    }
                });
                popup.show();
            }
        });
    }

    private RemoteCallback<Path> getRenameSuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                BasicFileMenuBuilderImpl.this.busyIndicatorView.hideBusyIndicator();
                BasicFileMenuBuilderImpl.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRenamedSuccessfully()));
            }
        };
    }

    @Override
    public BasicFileMenuBuilder addRename(final Path path, final Validator validator, final Caller<? extends SupportsRename> renameCaller) {
        return this.addRename(new Command(){

            public void execute() {
                RenamePopup popup = new RenamePopup(path, validator, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        BasicFileMenuBuilderImpl.this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Renaming());
                        ((SupportsRename)renameCaller.call(BasicFileMenuBuilderImpl.this.getRenameSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)BasicFileMenuBuilderImpl.this.busyIndicatorView))).rename(path, details.getNewFileName(), details.getCommitMessage());
                    }
                });
                popup.show();
            }
        });
    }

    @Override
    public BasicFileMenuBuilder addCopy(Command command) {
        this.copyCommand = command;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addCopy(final Path path, final Caller<? extends SupportsCopy> copyCaller) {
        return this.addCopy(new Command(){

            public void execute() {
                CopyPopup popup = new CopyPopup(path, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        BasicFileMenuBuilderImpl.this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Copying());
                        ((SupportsCopy)copyCaller.call(BasicFileMenuBuilderImpl.this.getCopySuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)BasicFileMenuBuilderImpl.this.busyIndicatorView))).copy(path, details.getNewFileName(), details.getCommitMessage());
                    }
                });
                popup.show();
            }
        });
    }

    @Override
    public BasicFileMenuBuilder addCopy(final Path path, final Validator validator, final Caller<? extends SupportsCopy> copyCaller) {
        return this.addCopy(new Command(){

            public void execute() {
                CopyPopup popup = new CopyPopup(path, validator, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        BasicFileMenuBuilderImpl.this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Copying());
                        ((SupportsCopy)copyCaller.call(BasicFileMenuBuilderImpl.this.getCopySuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)BasicFileMenuBuilderImpl.this.busyIndicatorView))).copy(path, details.getNewFileName(), details.getCommitMessage());
                    }
                });
                popup.show();
            }
        });
    }

    private RemoteCallback<Path> getCopySuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                BasicFileMenuBuilderImpl.this.busyIndicatorView.hideBusyIndicator();
                BasicFileMenuBuilderImpl.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCopiedSuccessfully()));
            }
        };
    }

    @Override
    public BasicFileMenuBuilder addValidate(Command validateCommand) {
        this.validateCommand = validateCommand;
        return this;
    }

    @Override
    public BasicFileMenuBuilder addRestoreVersion(Path path) {
        this.restoreCommand = this.restoreVersionCommandProvider.getCommand(path);
        return this;
    }

    @Override
    public BasicFileMenuBuilder addCommand(String caption, Command command) {
        this.otherCommands.add((Pair<String, Command>)new Pair((Object)caption, (Object)command));
        return this;
    }

    @Override
    public Menus build() {
        final LinkedHashMap<MenuItems, Object> menuItems = new LinkedHashMap<MenuItems, Object>();
        if (this.saveCommand != null) {
            menuItems.put(MenuItems.SAVE, ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Save()).respondsWith(this.saveCommand)).endMenu()).build().getItems().get(0));
        } else if (this.saveMenuItem != null) {
            menuItems.put(MenuItems.SAVE, this.saveMenuItem);
            this.menuItemsSyncedWithLockState.add(this.saveMenuItem);
        }
        if (this.deleteCommand != null) {
            if (this.deleteMenuItem == null) {
                this.deleteMenuItem = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Delete()).respondsWith(this.deleteCommand)).endMenu()).build().getItems().get(0);
            }
            menuItems.put(MenuItems.DELETE, this.deleteMenuItem);
            this.menuItemsSyncedWithLockState.add(this.deleteMenuItem);
        }
        if (this.renameCommand != null) {
            if (this.renameMenuItem == null) {
                this.renameMenuItem = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Rename()).respondsWith(this.renameCommand)).endMenu()).build().getItems().get(0);
            }
            menuItems.put(MenuItems.RENAME, this.renameMenuItem);
            this.menuItemsSyncedWithLockState.add(this.renameMenuItem);
        }
        if (this.copyCommand != null) {
            menuItems.put(MenuItems.COPY, ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Copy()).respondsWith(this.copyCommand)).endMenu()).build().getItems().get(0));
        }
        if (this.validateCommand != null) {
            menuItems.put(MenuItems.VALIDATE, ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Validate()).respondsWith(this.validateCommand)).endMenu()).build().getItems().get(0));
        }
        if (this.restoreCommand != null) {
            if (this.restoreMenuItem == null) {
                this.restoreMenuItem = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Restore()).respondsWith(this.restoreCommand)).endMenu()).build().getItems().get(0);
            }
            this.menuItemsSyncedWithLockState.add(this.restoreMenuItem);
        }
        if (this.otherCommands != null && !this.otherCommands.isEmpty()) {
            ArrayList otherMenuItems = new ArrayList();
            for (Pair<String, Command> other : this.otherCommands) {
                otherMenuItems.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)((String)other.getK1())).respondsWith((Command)other.getK2())).endMenu()).build().getItems().get(0));
            }
            MenuItem item = (MenuItem)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Other()).withItems(otherMenuItems).endMenu()).build().getItems().get(0);
            menuItems.put((MenuItems)item, item);
        }
        for (MenuItem menuItem : this.topLevelMenus) {
            menuItems.put((MenuItems)menuItem, menuItem);
        }
        return new Menus(){

            public List<MenuItem> getItems() {
                return new ArrayList<MenuItem>(){
                    {
                        for (MenuItem menuItem : menuItems.values()) {
                            this.add(menuItem);
                        }
                    }
                };
            }

            public Map<Object, MenuItem> getItemsMap() {
                return menuItems;
            }

            public void accept(MenuVisitor visitor) {
                if (visitor.visitEnter((Menus)this)) {
                    for (MenuItem item : menuItems.values()) {
                        item.accept(visitor);
                    }
                    visitor.visitLeave((Menus)this);
                }
            }
        };
    }

    @Override
    public BasicFileMenuBuilder addNewTopLevelMenu(MenuItem menu) {
        this.topLevelMenus.add(menu);
        return this;
    }

    private void onEditorLockInfo(@Observes UpdatedLockStatusEvent lockInfo) {
        boolean enabled = !lockInfo.isLocked() || lockInfo.isLockedByCurrentUser();
        for (MenuItem menuItem : this.menuItemsSyncedWithLockState) {
            menuItem.setEnabled(enabled);
        }
    }
}

