/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import java.lang.annotation.Annotation;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.CopyPopupView;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

public class CopyPopup
implements CopyPopupView.Presenter {
    private final CopyPopupView view;
    private final Path path;
    private final Validator validator;
    private final CommandWithFileNameAndCommitMessage command;

    public CopyPopup(Path path, CommandWithFileNameAndCommitMessage command) {
        this(path, command, CopyPopup.getDefaultView());
    }

    public CopyPopup(Path path, CommandWithFileNameAndCommitMessage command, CopyPopupView view) {
        this(path, new Validator(){

            @Override
            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        }, command, view);
    }

    public CopyPopup(Path path, Validator validator, CommandWithFileNameAndCommitMessage command) {
        this(path, validator, command, CopyPopup.getDefaultView());
    }

    public CopyPopup(Path path, Validator validator, CommandWithFileNameAndCommitMessage command, CopyPopupView view) {
        this.validator = (Validator)PortablePreconditions.checkNotNull((String)"validator", (Object)validator);
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.command = (CommandWithFileNameAndCommitMessage)PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.view = (CopyPopupView)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        this.view.init(this);
    }

    public void show() {
        this.view.show();
    }

    private void hide() {
        this.view.hide();
    }

    @Override
    public void onCancel() {
        this.hide();
    }

    @Override
    public void onCopy() {
        final String baseFileName = this.view.getNewName();
        String originalFileName = this.path.getFileName();
        String extension = originalFileName.lastIndexOf(".") > 0 ? originalFileName.substring(originalFileName.lastIndexOf(".")) : "";
        String fileName = baseFileName + extension;
        this.validator.validate(fileName, new ValidatorWithReasonCallback(){

            @Override
            public void onFailure(String reason) {
                if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    CopyPopup.this.view.handleDuplicatedFileName();
                } else {
                    CopyPopup.this.view.handleInvalidFileName();
                }
            }

            @Override
            public void onSuccess() {
                CopyPopup.this.command.execute(new FileNameAndCommitMessage(baseFileName, CopyPopup.this.view.getCheckInComment()));
            }

            @Override
            public void onFailure() {
                CopyPopup.this.view.handleInvalidFileName();
            }
        });
    }

    public static CopyPopupView getDefaultView() {
        return (CopyPopupView)IOC.getBeanManager().lookupBean(CopyPopupView.class, new Annotation[0]).getInstance();
    }
}

