/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.java.nio.base.version.VersionRecord;

public class VersionMenuItemLabel
extends Composite {
    private final Callback<VersionRecord> selectionCallback;
    private VersionRecord versionRecord;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    VersionMenuItemStyle style;
    @UiField
    FocusPanel base;
    @UiField
    InlineLabel author;
    @UiField
    InlineLabel date;
    @UiField
    Label comment;
    @UiField
    HTMLPanel panel;
    @UiField
    InlineLabel number;
    @UiField
    DivElement authorContainer;

    public VersionMenuItemLabel(VersionRecord versionRecord, Integer number, boolean isSelected, Callback<VersionRecord> selectionCallback) {
        this.versionRecord = versionRecord;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (isSelected) {
            this.setSelected();
        }
        this.selectionCallback = selectionCallback;
        this.number.setText(number.toString());
        this.author.setText(versionRecord.author());
        this.date.setText(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(versionRecord.date()));
        this.comment.setText(this.snip(versionRecord.comment()));
        this.base.setTitle(versionRecord.comment());
    }

    private void setSelected() {
        this.panel.addStyleName(this.style.selected());
        this.panel.removeStyleName(this.style.normal());
        this.authorContainer.addClassName(this.style.authorSelected());
        this.authorContainer.removeClassName(this.style.author());
    }

    private String snip(String comment) {
        if (comment != null && comment.length() >= 60) {
            return comment.substring(0, 58) + " ...";
        }
        return comment;
    }

    @UiHandler(value={"base"})
    public void handleClick(ClickEvent event) {
        if (this.selectionCallback != null) {
            this.selectionCallback.callback((Object)this.versionRecord);
        }
    }

    static interface Binder
    extends UiBinder<Widget, VersionMenuItemLabel> {
    }

    public static interface VersionMenuItemStyle
    extends CssResource {
        public String normal();

        public String selected();

        public String comment();

        public String version();

        public String author();

        public String authorSelected();
    }
}

