/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.Customizable;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@Dependent
public class CopyPopUpPresenter {
    private Path path;
    private Validator validator;
    private CommandWithFileNameAndCommitMessage command;
    private ToggleCommentPresenter toggleCommentPresenter;
    private View view;

    @Inject
    public CopyPopUpPresenter(@Customizable View view, ToggleCommentPresenter toggleCommentPresenter) {
        this.view = view;
        this.toggleCommentPresenter = toggleCommentPresenter;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(Path path, Validator validator, CommandWithFileNameAndCommitMessage command) {
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.validator = (Validator)PortablePreconditions.checkNotNull((String)"validator", (Object)validator);
        this.command = (CommandWithFileNameAndCommitMessage)PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.view.show();
    }

    public void show(Path path, CommandWithFileNameAndCommitMessage copyPopupCommand) {
        this.show(path, this.defaultValidator(), copyPopupCommand);
    }

    public void cancel() {
        this.view.hide();
    }

    public View getView() {
        return this.view;
    }

    public void copy(String newName) {
        String newFileName = newName + this.extension(this.path.getFileName());
        this.validator.validate(newFileName, this.validatorCallback(this.toggleCommentPresenter.getComment(), newName));
    }

    public ToggleCommentPresenter getToggleCommentPresenter() {
        return this.toggleCommentPresenter;
    }

    private String extension(String fileName) {
        return fileName.lastIndexOf(".") > 0 ? fileName.substring(fileName.lastIndexOf(".")) : "";
    }

    private Validator defaultValidator() {
        return new Validator(){

            @Override
            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        };
    }

    private ValidatorWithReasonCallback validatorCallback(final String commemt, final String baseFileName) {
        return new ValidatorWithReasonCallback(){

            @Override
            public void onFailure(String reason) {
                if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    CopyPopUpPresenter.this.view.handleDuplicatedFileName();
                } else {
                    CopyPopUpPresenter.this.view.handleInvalidFileName();
                }
            }

            @Override
            public void onSuccess() {
                CopyPopUpPresenter.this.command.execute(new FileNameAndCommitMessage(baseFileName, commemt));
            }

            @Override
            public void onFailure() {
                CopyPopUpPresenter.this.view.handleInvalidFileName();
            }
        };
    }

    public Path getPath() {
        return this.path;
    }

    Validator getValidator() {
        return this.validator;
    }

    CommandWithFileNameAndCommitMessage getCommand() {
        return this.command;
    }

    public static interface View
    extends UberElement<CopyPopUpPresenter> {
        public void show();

        public void hide();

        public void handleDuplicatedFileName();

        public void handleInvalidFileName();

        public Path getTargetPath();

        public String getPackageName();
    }
}

