/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.annotations.FallbackImplementation;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
@FallbackImplementation
public class CopyPopUpView
implements CopyPopUpPresenter.View,
IsElement {
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="newNameTextBox")
    TextBox newNameTextBox;
    @Inject
    @DataField(value="error")
    Div error;
    @Inject
    @DataField(value="errorMessage")
    Span errorMessage;
    @Inject
    private TranslationService translationService;
    private CopyPopUpPresenter presenter;
    private BaseModal modal;

    public void init(CopyPopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
        this.setupComment();
    }

    @Override
    public void show() {
        this.errorSetup();
        this.newNameTextBoxSetup();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void handleDuplicatedFileName() {
        this.showError(this.translate("CopyPopUpView.FileAlreadyExists", this.newNameTextBox.getValue()));
    }

    @Override
    public void handleInvalidFileName() {
        this.showError(this.translate("CopyPopUpView.InvalidFileName", this.newNameTextBox.getValue()));
    }

    @Override
    public Path getTargetPath() {
        return null;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.translate("CopyPopUpView.MakeACopy", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(this.translate("CopyPopUpView.Cancel", new Object[0]), this.cancelCommand(), ButtonType.DEFAULT);
        footer.addButton(this.translate("CopyPopUpView.MakeACopy", new Object[0]), this.copyCommand(), ButtonType.PRIMARY);
        return footer;
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    private Command copyCommand() {
        return () -> this.presenter.copy(this.newNameTextBox.getValue());
    }

    private void newNameTextBoxSetup() {
        this.newNameTextBox.setValue((Object)"");
    }

    private void errorSetup() {
        this.error.setHidden(true);
    }

    private void showError(String errorMessage) {
        this.errorMessage.setTextContent(errorMessage);
        this.error.setHidden(false);
    }

    private Command cancelCommand() {
        return () -> this.presenter.cancel();
    }

    private void setupComment() {
        this.body.appendChild((Node)this.toggleCommentPresenter().getViewElement());
    }

    private ToggleCommentPresenter toggleCommentPresenter() {
        return this.presenter.getToggleCommentPresenter();
    }
}

