/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups.elemental2;

import elemental2.dom.HTMLElement;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.TemplateUtil;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

public abstract class Elemental2Modal<V extends View> {
    private final V view;
    private BaseModal modal;
    private boolean isShowing;

    public Elemental2Modal(V view) {
        this.view = view;
    }

    public void setup() {
        this.superSetup();
    }

    public void superSetup() {
        this.view.init((Object)this);
        this.modal = new CommonModalBuilder().addHeader(this.getHeader()).addBody(this.getBody()).addFooter(this.getFooter()).build();
        this.modal.addHideHandler(i -> {
            this.isShowing = false;
        });
    }

    private String getHeader() {
        return this.view.getHeader();
    }

    private org.jboss.errai.common.client.dom.HTMLElement getFooter() {
        return TemplateUtil.asErraiElement((Object)this.view.getFooter());
    }

    private org.jboss.errai.common.client.dom.HTMLElement getBody() {
        return TemplateUtil.asErraiElement((Object)this.view.getBody());
    }

    public void show() {
        if (!this.isShowing) {
            this.modal.show();
            this.isShowing = true;
        }
    }

    protected void setWidth(String width) {
        this.modal.setWidth(width);
    }

    public void hide() {
        this.modal.hide();
        this.isShowing = false;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public V getView() {
        return this.view;
    }

    public BaseModal getModal() {
        return this.modal;
    }

    public static interface View<P extends Elemental2Modal<? extends View>>
    extends UberElemental<P>,
    IsElement {
        public String getHeader();

        public HTMLElement getBody();

        public HTMLElement getFooter();
    }
}

