/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.validation;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.validation.Preconditions;

public class PreconditionsTest {
    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotEmptyArray() {
        Preconditions.checkNotEmpty((String)"notEmpty", (Object[])new Object[]{1, 2, 3});
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotEmptyParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)"notEmpty");
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotNullParameter() {
        Preconditions.checkNotNull((String)"notNullable", (Object)"notNullValue");
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNullParameter() {
        Preconditions.checkNullMandatory((String)"nullable", null);
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingValidConditionParameter() {
        Preconditions.checkCondition((String)"valid", (boolean)true);
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettinOnlyNonNullParameters() {
        Preconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new String[]{"nonNull"});
        Preconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new String[]{"nonNull", "anotherNonNull"});
    }

    @Test
    public void shouldGetCorrectErrorNessage() {
        try {
            Preconditions.checkNotNull((String)"notNullable", null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Parameter named 'notNullable' should be not null!"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnCheckEmptyWhenGettingNullParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettinAllNullParameter() {
        Preconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new Object[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingEmptyArray() {
        Preconditions.checkNotEmpty((String)"empty", (Object[])new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingEmptyParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)"");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenGettingInvalidConditionParameter() {
        Preconditions.checkCondition((String)"valid", (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNonNullParameter() {
        Preconditions.checkNullMandatory((String)"nullable", (Object)"non null");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNullArray() {
        Preconditions.checkNotEmpty((String)"empty", (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNullParameter() {
        Preconditions.checkNotNull((String)"notNullable", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingSpacedParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)"    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettinOneNullParameter() {
        Preconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new String[]{"nonNull", null});
    }
}

