/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.async;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.Asynchronous;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveThreadFactory;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SimpleAsyncExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAsyncExecutorService.class);
    private static final Integer AWAIT_TERMINATION_TIMEOUT = Integer.parseInt(System.getProperty("org.uberfire.watcher.quitetimeout", "3"));
    private static final Object lock = new Object();
    private final ExecutorService executorService;
    private static SimpleAsyncExecutorService instance;
    private static SimpleAsyncExecutorService unmanagedInstance;
    private final AtomicBoolean hasAlreadyShutdown = new AtomicBoolean(false);
    private final Set<Future<?>> jobs = new CopyOnWriteArraySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleAsyncExecutorService getDefaultInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                SimpleAsyncExecutorService _executorManager = null;
                try {
                    _executorManager = (SimpleAsyncExecutorService)InitialContext.doLookup("java:module/SimpleAsyncExecutorService");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                instance = _executorManager == null ? new SimpleAsyncExecutorService(false) : _executorManager;
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleAsyncExecutorService getUnmanagedInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance != null && SimpleAsyncExecutorService.instance.executorService != null) {
                return instance;
            }
            if (unmanagedInstance == null) {
                unmanagedInstance = new SimpleAsyncExecutorService(false);
            }
            return unmanagedInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownInstances() {
        Object object = lock;
        synchronized (object) {
            if (unmanagedInstance != null) {
                unmanagedInstance.shutdown();
            }
            if (instance != null && SimpleAsyncExecutorService.instance.executorService != null) {
                instance.shutdown();
            }
        }
    }

    public SimpleAsyncExecutorService() {
        this.executorService = null;
    }

    public SimpleAsyncExecutorService(boolean notEJB) {
        this.executorService = Executors.newCachedThreadPool(new DescriptiveThreadFactory());
    }

    @Asynchronous
    @Lock(value=LockType.READ)
    public void execute(Runnable r) {
        if (this.executorService != null) {
            this.jobs.add(this.executorService.submit(r));
        } else {
            r.run();
        }
    }

    private void shutdown() {
        if (!this.hasAlreadyShutdown.getAndSet(true) && this.executorService != null) {
            for (Future<?> job : this.jobs) {
                if (job.isCancelled() || job.isDone()) continue;
                job.cancel(true);
            }
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(AWAIT_TERMINATION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(AWAIT_TERMINATION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                        LOG.error("Thread pool did not terminate.");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.executorService.shutdown();
        }
    }
}

