/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.async;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.Asynchronous;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.commons.async.DisposableExecutor;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SimpleAsyncExecutorService
implements DisposableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAsyncExecutorService.class);
    private static final Integer AWAIT_TERMINATION_TIMEOUT = Integer.parseInt(System.getProperty("org.uberfire.watcher.quitetimeout", "3"));
    private static final boolean USE_EXECUTOR_SAFE_MODE = Boolean.parseBoolean(System.getProperty("org.uberfire.async.executor.safemode", "false"));
    private static final Object lock = new Object();
    private static final AtomicBoolean isEJB = new AtomicBoolean(false);
    private final ExecutorService executorService;
    private static DisposableExecutor defaultInstance;
    private static DisposableExecutor managedInstance;
    private static DisposableExecutor unmanagedInstance;
    private final AtomicBoolean hasAlreadyShutdown = new AtomicBoolean(false);
    private final Set<Future<?>> jobs = new CopyOnWriteArraySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisposableExecutor getDefaultInstance() {
        Object object = lock;
        synchronized (object) {
            if (defaultInstance == null) {
                DisposableExecutor _executorManager = null;
                if (!USE_EXECUTOR_SAFE_MODE) {
                    try {
                        _executorManager = (DisposableExecutor)InitialContext.doLookup("java:module/SimpleAsyncExecutorService");
                        isEJB.set(true);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to instantiate EJB Asynchronous Bean. Falling back to Executors' CachedThreadPool.", (Throwable)e);
                    }
                } else {
                    LOG.info("Use of to Executors' CachedThreadPool has been requested; overriding container provisioning.");
                }
                if (_executorManager == null) {
                    if (unmanagedInstance == null) {
                        unmanagedInstance = new SimpleAsyncExecutorService(false);
                    }
                    defaultInstance = unmanagedInstance;
                } else {
                    if (managedInstance == null) {
                        managedInstance = _executorManager;
                    }
                    defaultInstance = managedInstance;
                }
            }
        }
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisposableExecutor getUnmanagedInstance() {
        Object object = lock;
        synchronized (object) {
            if (unmanagedInstance == null) {
                unmanagedInstance = new SimpleAsyncExecutorService(false);
            }
            return unmanagedInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownInstances() {
        Object object = lock;
        synchronized (object) {
            if (!isEJB.get() && managedInstance != null) {
                managedInstance.dispose();
            }
            if (unmanagedInstance != null) {
                unmanagedInstance.dispose();
            }
        }
    }

    public SimpleAsyncExecutorService() {
        this.executorService = null;
    }

    public SimpleAsyncExecutorService(boolean notEJB) {
        this.executorService = Executors.newCachedThreadPool(new DescriptiveThreadFactory());
    }

    @Override
    @Asynchronous
    @Lock(value=LockType.READ)
    public void execute(Runnable r) {
        if (this.executorService != null) {
            this.jobs.add(this.executorService.submit(r));
        } else {
            r.run();
        }
    }

    @Override
    public void dispose() {
        if (!this.hasAlreadyShutdown.getAndSet(true) && this.executorService != null) {
            for (Future<?> job : this.jobs) {
                if (job.isCancelled() || job.isDone()) continue;
                job.cancel(true);
            }
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(AWAIT_TERMINATION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(AWAIT_TERMINATION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                        LOG.error("Thread pool did not terminate.");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.executorService.shutdown();
        }
    }

    static void recycle() {
        defaultInstance = null;
        managedInstance = null;
        unmanagedInstance = null;
    }
}

