/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.async;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.async.DisposableExecutor;
import org.uberfire.commons.async.SimpleAsyncExecutorService;

public class SimpleAsyncExecutorServiceTest {
    private String spUberfireAsyncExecutorSafeMode;
    private String spJavaNamingFactoryInitial;

    @Before
    public void before() {
        SimpleAsyncExecutorService.recycle();
        this.spUberfireAsyncExecutorSafeMode = System.getProperty("org.uberfire.async.executor.safemode");
        this.spJavaNamingFactoryInitial = System.getProperty("java.naming.factory.initial");
        System.clearProperty("org.uberfire.async.executor.safemode");
        System.clearProperty("java.naming.factory.initial");
    }

    @After
    public void after() {
        if (this.spUberfireAsyncExecutorSafeMode != null) {
            System.setProperty("org.uberfire.async.executor.safemode", this.spUberfireAsyncExecutorSafeMode);
        }
        if (this.spJavaNamingFactoryInitial != null) {
            System.setProperty("java.naming.factory.initial", this.spJavaNamingFactoryInitial);
        }
    }

    @Test
    public void testUseJDNILookup() throws NamingException {
        System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
        Context context = (Context)Mockito.mock(Context.class);
        DisposableExecutor service = (DisposableExecutor)Mockito.mock(DisposableExecutor.class);
        Mockito.when((Object)context.lookup("java:module/SimpleAsyncExecutorService")).thenReturn((Object)service);
        MockInitialContextFactory.setCurrentContext(context);
        DisposableExecutor executor1 = SimpleAsyncExecutorService.getDefaultInstance();
        Assert.assertNotNull((Object)executor1);
        Assert.assertTrue((boolean)(executor1 instanceof DisposableExecutor));
        Assert.assertSame((Object)service, (Object)executor1);
        DisposableExecutor executor2 = SimpleAsyncExecutorService.getDefaultInstance();
        Assert.assertNotNull((Object)executor2);
        Assert.assertTrue((boolean)(executor2 instanceof DisposableExecutor));
        Assert.assertSame((Object)service, (Object)executor2);
        Assert.assertSame((Object)executor1, (Object)executor2);
    }

    @Test
    public void testUseExecutorThreadPool() {
        System.setProperty("org.uberfire.async.executor.safemode", "true");
        DisposableExecutor executor1 = SimpleAsyncExecutorService.getDefaultInstance();
        Assert.assertNotNull((Object)executor1);
        Assert.assertTrue((boolean)(executor1 instanceof SimpleAsyncExecutorService));
        DisposableExecutor executor2 = SimpleAsyncExecutorService.getDefaultInstance();
        Assert.assertNotNull((Object)executor2);
        Assert.assertTrue((boolean)(executor2 instanceof SimpleAsyncExecutorService));
        Assert.assertSame((Object)executor1, (Object)executor2);
    }

    public static class MockInitialContextFactory
    implements InitialContextFactory {
        private static final ThreadLocal<Context> currentContext = new ThreadLocal();

        public static void setCurrentContext(Context context) {
            currentContext.set(context);
        }

        @Override
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            return currentContext.get();
        }
    }
}

