/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.message.MessageType;

abstract class BaseLockExecuteNotifyReleaseTemplate<V> {
    public static final int TIMEOUT = Integer.parseInt(System.getProperty("org.uberfire.cluster.timeout", "30000"));

    BaseLockExecuteNotifyReleaseTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V execute(ClusterService clusterService, RunnableFuture<V> task) {
        try {
            clusterService.lock();
            task.run();
            Object result = task.get();
            this.sendMessage(clusterService);
            Object v = result;
            return v;
        }
        catch (ExecutionException e) {
            this.throwException(e.getCause());
        }
        catch (Exception e) {
            this.throwException(e);
        }
        finally {
            clusterService.unlock();
        }
        return null;
    }

    private void throwException(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    abstract void sendMessage(ClusterService var1);

    public abstract MessageType getMessageType();

    public abstract String getServiceId();

    public abstract Map<String, String> buildContent();
}

