/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;

@RunWith(value=MockitoJUnitRunner.class)
public class ClusterJMSServiceTest {
    private ClusterService clusterService;
    private ActiveMQConnectionFactory factory;
    private Connection connection;
    private Session session1;
    private Session session2;

    @Before
    public void setup() throws JMSException {
        this.factory = (ActiveMQConnectionFactory)Mockito.mock(ActiveMQConnectionFactory.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.factory.createConnection()).thenReturn((Object)this.connection);
        this.session1 = (Session)Mockito.mock(Session.class);
        this.session2 = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.connection.createSession(Mockito.eq((boolean)false), Mockito.eq((int)1))).thenReturn((Object)this.session1, (Object[])new Session[]{this.session2});
        this.clusterService = new ClusterJMSService(){

            ActiveMQConnectionFactory createConnectionFactory(String jmsURL, String jmsUserName, String jmsPassword) {
                return ClusterJMSServiceTest.this.factory;
            }
        };
    }

    @Test
    public void connectTest() throws JMSException {
        this.clusterService.connect();
        ((Connection)Mockito.verify((Object)this.connection)).setExceptionListener((ExceptionListener)Mockito.any());
        ((Connection)Mockito.verify((Object)this.connection)).start();
    }

    @Test
    public void sessionConsumersCreatedShouldBeClosed() throws JMSException {
        this.clusterService.connect();
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, "dora_destination", Object.class, l -> {});
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, "dora_destination", Object.class, l -> {});
        this.clusterService.close();
        ((Session)Mockito.verify((Object)this.session1)).close();
        ((Session)Mockito.verify((Object)this.session2)).close();
        ((Connection)Mockito.verify((Object)this.connection)).close();
    }
}

