/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterParameters;
import org.uberfire.commons.cluster.ClusterService;

public class ClusterJMSService
implements ClusterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterJMSService.class);
    private Connection connection;
    private ClusterParameters clusterParameters;
    private List<Session> consumerSessions = new ArrayList<Session>();

    public ClusterJMSService() {
        this.clusterParameters = this.loadParameters();
    }

    @Override
    public void connect() {
        try {
            ConnectionFactory factory;
            String jmsUserName = this.clusterParameters.getJmsUserName();
            String jmsPassword = this.clusterParameters.getJmsPassword();
            switch (this.clusterParameters.getConnectionMode()) {
                case REMOTE: {
                    String jmsURL = this.clusterParameters.getProviderUrl();
                    factory = this.createRemoteConnectionFactory(jmsURL, jmsUserName, jmsPassword);
                    break;
                }
                case JNDI: {
                    InitialContext context = new InitialContext(this.clusterParameters.getInitialContextFactory());
                    factory = this.createJNDIConnectionFactory(context);
                    break;
                }
                default: {
                    throw new RuntimeException("Error setting the cluster mode (should be defined as REMOTE or JNDI");
                }
            }
            this.connection = this.thereIsNoCredentials(jmsUserName, jmsPassword) ? factory.createConnection() : factory.createConnection(jmsUserName, jmsPassword);
            this.connection.setExceptionListener((ExceptionListener)new JMSExceptionListener());
            this.connection.start();
        }
        catch (Exception e) {
            LOGGER.error("Error connecting on JMS " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private boolean thereIsNoCredentials(String jmsUserName, String jmsPassword) {
        return jmsUserName == null && jmsPassword == null;
    }

    ConnectionFactory createJNDIConnectionFactory(InitialContext context) throws NamingException {
        return (ConnectionFactory)context.lookup(this.clusterParameters.getJmsConnectionFactoryJndiName());
    }

    ConnectionFactory createRemoteConnectionFactory(String jmsURL, String jmsUserName, String jmsPassword) {
        return new ActiveMQConnectionFactory(jmsURL, jmsUserName, jmsPassword);
    }

    private ClusterParameters loadParameters() {
        return new ClusterParameters();
    }

    @Override
    public <T> void createConsumer(ClusterService.DestinationType type, String channel, Class<T> objectMessageClass, Consumer<T> listener) {
        try {
            Session session = this.createConsumerSession();
            Destination topic = this.createDestination(type, channel, session);
            MessageConsumer messageConsumer = session.createConsumer(topic);
            messageConsumer.setMessageListener(message -> {
                if (message instanceof ObjectMessage) {
                    try {
                        Serializable object = ((ObjectMessage)message).getObject();
                        if (objectMessageClass.isInstance(object)) {
                            listener.accept(object);
                        }
                    }
                    catch (JMSException e) {
                        LOGGER.error("Exception receiving JMS message: " + e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error creating JMS Watch Service: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void broadcast(ClusterService.DestinationType type, String channel, Serializable object) {
        Session session = null;
        try {
            session = this.connection.createSession(false, 1);
            Destination destination = this.createDestination(type, channel, session);
            ObjectMessage objectMessage = session.createObjectMessage(object);
            if (this.clusterParameters.getJmsThrottle() > 0L) {
                objectMessage.setLongProperty("_AMQ_SCHED_DELIVERY", System.currentTimeMillis() + this.clusterParameters.getJmsThrottle());
            }
            MessageProducer messageProducer = session.createProducer(destination);
            messageProducer.send((Message)objectMessage);
        }
        catch (JMSException e) {
            LOGGER.error("Exception on JMS broadcast: " + e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.error("Exception on closing JMS session (this could trigger a leak) " + e.getMessage());
                }
            }
        }
    }

    private Destination createDestination(ClusterService.DestinationType type, String channel, Session session) throws JMSException {
        if (type.equals((Object)ClusterService.DestinationType.LoadBalancer)) {
            return session.createQueue(channel);
        }
        return session.createTopic(channel);
    }

    private Session createConsumerSession() {
        try {
            Session session = this.connection.createSession(false, 1);
            this.consumerSessions.add(session);
            return session;
        }
        catch (JMSException e) {
            LOGGER.error("Error creating session " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAppFormerClustered() {
        return this.clusterParameters.isAppFormerClustered();
    }

    @Override
    public void close() {
        try {
            for (Session s : this.consumerSessions) {
                s.close();
            }
            this.connection.close();
        }
        catch (JMSException e) {
            LOGGER.error("Exception closing JMS connection and consumerSessions: " + e.getMessage());
        }
    }

    public static class JMSExceptionListener
    implements ExceptionListener {
        public void onException(JMSException e) {
            LOGGER.error("JMSException: " + e.getMessage());
        }
    }
}

