/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.Association;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.channel.sctp.AbstractWriteRequestQueue;
import io.netty.channel.sctp.DefaultNioSctpChannelConfig;
import io.netty.channel.sctp.NioSctpChannelConfig;
import io.netty.channel.sctp.SctpBindAddressEvent;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpFrame;
import io.netty.channel.sctp.SctpSendBufferPool;
import io.netty.channel.sctp.SctpUnbindAddressEvent;
import io.netty.channel.sctp.SctpWorker;
import io.netty.util.internal.ThreadLocalBoolean;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class SctpChannelImpl
extends AbstractChannel
implements SctpChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    volatile int state = 0;
    final com.sun.nio.sctp.SctpChannel channel;
    final SctpWorker worker;
    private final NioSctpChannelConfig config;
    private volatile InetSocketAddress localAddress;
    private volatile InetSocketAddress remoteAddress;
    final Object interestOpsLock = new Object();
    final Object writeLock = new Object();
    final Runnable writeTask = new WriteTask();
    final AtomicBoolean writeTaskInTaskQueue = new AtomicBoolean();
    final Queue<MessageEvent> writeBuffer = new WriteRequestQueue();
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    boolean inWriteNowLoop;
    boolean writeSuspended;
    MessageEvent currentWriteEvent;
    SctpSendBufferPool.SendBuffer currentWriteBuffer;

    public SctpChannelImpl(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, com.sun.nio.sctp.SctpChannel channel, SctpWorker worker) {
        super(parent, factory, pipeline, sink);
        this.channel = channel;
        this.worker = worker;
        this.config = new DefaultNioSctpChannelConfig(channel);
        this.getCloseFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                SctpChannelImpl.this.state = -1;
            }
        });
    }

    @Override
    public NioSctpChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                Iterator<SocketAddress> iterator = this.channel.getAllLocalAddresses().iterator();
                if (iterator.hasNext()) {
                    this.localAddress = localAddress = (InetSocketAddress)iterator.next();
                }
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    @Override
    public Set<InetSocketAddress> getAllLocalAddresses() {
        try {
            Set<SocketAddress> allLocalAddresses = this.channel.getAllLocalAddresses();
            HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>(allLocalAddresses.size());
            for (SocketAddress socketAddress : allLocalAddresses) {
                addresses.add((InetSocketAddress)socketAddress);
            }
            return addresses;
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                Iterator<SocketAddress> iterator = this.channel.getRemoteAddresses().iterator();
                if (iterator.hasNext()) {
                    this.remoteAddress = remoteAddress = (InetSocketAddress)iterator.next();
                }
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    @Override
    public Set<InetSocketAddress> getAllRemoteAddresses() {
        try {
            Set<SocketAddress> allLocalAddresses = this.channel.getRemoteAddresses();
            HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>(allLocalAddresses.size());
            for (SocketAddress socketAddress : allLocalAddresses) {
                addresses.add((InetSocketAddress)socketAddress);
            }
            return addresses;
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }

    @Override
    public ChannelFuture bindAddress(InetAddress localAddress) {
        ChannelFuture future = Channels.future(this);
        this.getPipeline().sendDownstream(new SctpBindAddressEvent(this, future, localAddress));
        return future;
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress localAddress) {
        ChannelFuture future = Channels.future(this);
        this.getPipeline().sendDownstream(new SctpUnbindAddressEvent(this, future, localAddress));
        return future;
    }

    @Override
    public Association association() {
        try {
            return this.channel.association();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.state >= 0;
    }

    @Override
    public boolean isBound() {
        return this.state >= 1;
    }

    @Override
    public boolean isConnected() {
        return this.state == 2;
    }

    final void setBound() {
        assert (this.state == 0) : "Invalid state: " + this.state;
        this.state = 1;
    }

    final void setConnected() {
        if (this.state != -1) {
            this.state = 2;
        }
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    @Override
    public int getInterestOps() {
        int highWaterMark;
        int lowWaterMark;
        if (!this.isOpen()) {
            return 4;
        }
        int interestOps = this.getRawInterestOps();
        int writeBufferSize = this.writeBufferSize.get();
        interestOps = writeBufferSize != 0 ? (this.highWaterMarkCounter.get() > 0 ? (writeBufferSize >= (lowWaterMark = this.getConfig().getWriteBufferLowWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB)) : (writeBufferSize >= (highWaterMark = this.getConfig().getWriteBufferHighWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB))) : (interestOps &= 0xFFFFFFFB);
        return interestOps;
    }

    int getRawInterestOps() {
        return super.getInterestOps();
    }

    void setRawInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    @Override
    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }

    private final class WriteTask
    implements Runnable {
        WriteTask() {
        }

        @Override
        public void run() {
            SctpChannelImpl.this.writeTaskInTaskQueue.set(false);
            SctpChannelImpl.this.worker.writeFromTaskLoop(SctpChannelImpl.this);
        }
    }

    private final class WriteRequestQueue
    extends AbstractWriteRequestQueue {
        private static final long serialVersionUID = -246694024103520626L;
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();

        WriteRequestQueue() {
        }

        @Override
        public boolean offer(MessageEvent e) {
            int highWaterMark;
            boolean success = this.queue.offer(e);
            assert (success);
            int messageSize = this.getMessageSize(e);
            int newWriteBufferSize = SctpChannelImpl.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = SctpChannelImpl.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                SctpChannelImpl.this.highWaterMarkCounter.incrementAndGet();
                if (!((Boolean)this.notifying.get()).booleanValue()) {
                    this.notifying.set(Boolean.TRUE);
                    Channels.fireChannelInterestChanged(SctpChannelImpl.this);
                    this.notifying.set(Boolean.FALSE);
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e = (MessageEvent)this.queue.poll();
            if (e != null) {
                int messageSize = this.getMessageSize(e);
                int newWriteBufferSize = SctpChannelImpl.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = SctpChannelImpl.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    SctpChannelImpl.this.highWaterMarkCounter.decrementAndGet();
                    if (SctpChannelImpl.this.isConnected() && !((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(SctpChannelImpl.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return e;
        }

        private int getMessageSize(MessageEvent e) {
            Object m = e.getMessage();
            if (m instanceof SctpFrame) {
                return ((SctpFrame)m).getPayloadBuffer().readableBytes();
            }
            return 0;
        }
    }
}

