/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.UnsafeDetectUtil;
import io.netty.util.internal.LegacyLinkedTransferQueue;
import io.netty.util.internal.LinkedTransferQueue;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;

public final class QueueFactory {
    private static final boolean useUnsafe = UnsafeDetectUtil.isUnsafeFound(QueueFactory.class.getClassLoader());

    private QueueFactory() {
    }

    public static <T> BlockingQueue<T> createQueue(Class<T> itemClass) {
        if (useUnsafe) {
            return new LinkedTransferQueue();
        }
        return new LegacyLinkedTransferQueue();
    }

    public static <T> BlockingQueue<T> createQueue(Collection<? extends T> collection, Class<T> itemClass) {
        if (useUnsafe) {
            return new LinkedTransferQueue<T>(collection);
        }
        return new LegacyLinkedTransferQueue<T>(collection);
    }
}

