/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.config;

import java.util.List;
import javax.inject.Inject;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.PasswordService;

public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    @Inject
    private PasswordService secureService;

    public ConfigGroup newConfigGroup(ConfigType type, String name, String description) {
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setDescription(description);
        configGroup.setName(name);
        configGroup.setType(type);
        configGroup.setEnabled(true);
        return configGroup;
    }

    public ConfigItem<String> newConfigItem(String name, String valueType) {
        ConfigItem stringConfigItem = new ConfigItem();
        stringConfigItem.setName(name);
        stringConfigItem.setValue((Object)valueType);
        return stringConfigItem;
    }

    public ConfigItem<Boolean> newConfigItem(String name, boolean valueType) {
        ConfigItem booleanConfigItem = new ConfigItem();
        booleanConfigItem.setName(name);
        booleanConfigItem.setValue((Object)valueType);
        return booleanConfigItem;
    }

    public ConfigItem<String> newSecuredConfigItem(String name, String valueType) {
        ConfigItem stringConfigItem = new ConfigItem();
        stringConfigItem.setName(name);
        stringConfigItem.setValue((Object)this.secureService.encrypt(valueType));
        return stringConfigItem;
    }

    public ConfigItem<List> newConfigItem(String name, List valueType) {
        ConfigItem listConfigItem = new ConfigItem();
        listConfigItem.setName(name);
        listConfigItem.setValue((Object)valueType);
        return listConfigItem;
    }
}

