/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ChannelBufferFactory;
import io.netty.buffer.HeapChannelBufferFactory;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipelineFactory;
import java.util.Map;

public class DefaultServerChannelConfig
implements ChannelConfig {
    private volatile ChannelPipelineFactory pipelineFactory;
    private volatile ChannelBufferFactory bufferFactory = HeapChannelBufferFactory.getInstance();

    @Override
    public void setOptions(Map<String, Object> options) {
        for (Map.Entry<String, Object> e : options.entrySet()) {
            this.setOption(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (key.equals("pipelineFactory")) {
            this.setPipelineFactory((ChannelPipelineFactory)value);
        } else if (key.equals("bufferFactory")) {
            this.setBufferFactory((ChannelBufferFactory)value);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public ChannelPipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    @Override
    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        if (pipelineFactory == null) {
            throw new NullPointerException("pipelineFactory");
        }
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public ChannelBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public void setBufferFactory(ChannelBufferFactory bufferFactory) {
        if (bufferFactory == null) {
            throw new NullPointerException("bufferFactory");
        }
        this.bufferFactory = bufferFactory;
    }

    @Override
    public int getConnectTimeoutMillis() {
        return 0;
    }

    @Override
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
    }
}

