/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.ReceiveBufferSizePredictor;
import io.netty.channel.socket.oio.AbstractOioWorker;
import io.netty.channel.socket.oio.OioDatagramChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

class OioDatagramWorker
extends AbstractOioWorker<OioDatagramChannel> {
    OioDatagramWorker(OioDatagramChannel channel) {
        super(channel);
    }

    @Override
    boolean process() throws IOException {
        ReceiveBufferSizePredictor predictor = ((OioDatagramChannel)this.channel).getConfig().getReceiveBufferSizePredictor();
        byte[] buf = new byte[predictor.nextReceiveBufferSize()];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            ((OioDatagramChannel)this.channel).socket.receive(packet);
        }
        catch (InterruptedIOException e) {
            return true;
        }
        Channels.fireMessageReceived(this.channel, (Object)((OioDatagramChannel)this.channel).getConfig().getBufferFactory().getBuffer(buf, 0, packet.getLength()), packet.getSocketAddress());
        return true;
    }

    static void write(OioDatagramChannel channel, ChannelFuture future, Object message, SocketAddress remoteAddress) {
        try {
            DatagramPacket packet;
            ChannelBuffer buf = (ChannelBuffer)message;
            int offset = buf.readerIndex();
            int length = buf.readableBytes();
            ByteBuffer nioBuf = buf.toByteBuffer();
            if (nioBuf.hasArray()) {
                packet = new DatagramPacket(nioBuf.array(), nioBuf.arrayOffset() + offset, length);
            } else {
                byte[] arrayBuf = new byte[length];
                buf.getBytes(0, arrayBuf);
                packet = new DatagramPacket(arrayBuf, length);
            }
            if (remoteAddress != null) {
                packet.setSocketAddress(remoteAddress);
            }
            channel.socket.send(packet);
            Channels.fireWriteComplete(channel, (long)length);
            future.setSuccess();
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    static void disconnect(OioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        try {
            channel.socket.disconnect();
            future.setSuccess();
            if (connected) {
                Channels.fireChannelDisconnected(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

