/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class NonReentrantLock
extends AbstractQueuedSynchronizer
implements Lock {
    private static final long serialVersionUID = -833780837233068610L;
    private Thread owner;

    @Override
    public void lock() {
        this.acquire(1);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireNanos(1, unit.toNanos(time));
    }

    @Override
    public void unlock() {
        this.release(1);
    }

    public boolean isHeldByCurrentThread() {
        return this.isHeldExclusively();
    }

    @Override
    public Condition newCondition() {
        return new AbstractQueuedSynchronizer.ConditionObject(this);
    }

    @Override
    protected boolean tryAcquire(int acquires) {
        if (this.compareAndSetState(0, 1)) {
            this.owner = Thread.currentThread();
            return true;
        }
        return false;
    }

    @Override
    protected boolean tryRelease(int releases) {
        if (Thread.currentThread() != this.owner) {
            throw new IllegalMonitorStateException();
        }
        this.owner = null;
        this.setState(0);
        return true;
    }

    @Override
    protected boolean isHeldExclusively() {
        return this.getState() != 0 && this.owner == Thread.currentThread();
    }
}

